#include "input.h"

void llegeixFitxerPED(string f, dimint ni, dimint ns)
{
  ifstream arxiu;
  string a1, a2;
  string temp;
  int r;

  r = comprovaExistenciaFitxer(f);
  if(r == 0)
  {
    arxiu.open(f.c_str());
    
    for(dimint i=0; i<ni; i++)
    {
      arxiu >> mindividus[i].familyID;
      arxiu >> mindividus[i].individualID;
      arxiu >> mindividus[i].paternalID;
      arxiu >> mindividus[i].maternalID;
      arxiu >> mindividus[i].sex;
      arxiu >> temp;
      stringstream ss(temp);
      if( (ss >> mindividus[i].phenotype).fail() )
      {
        escriuError("Error. The phenotype of the individual " + mindividus[i].familyID + " " + mindividus[i].individualID + " is not an integer: " + temp);
      }

      
      for(dimint j=0; j<ns; j++)
      {
        arxiu >> a1 >> a2;
        msnps[j].introdueixGenotips(a1,a2);
      }
    }
        
    arxiu.close();
  }

  
}

void llegeixFitxerMAP(string f, dimint ns)
{
  ifstream arxiu;
  string temp[4];
  int r;
 
  r = comprovaExistenciaFitxer(f);
  if(r == 0)
  {
    arxiu.open(f.c_str());
    for(dimint i=0; i<ns; i++)
    {
      arxiu >> temp[0] >> temp[1] >> temp[2] >> temp[3];
      msnps[i].nom = temp[1];
    }
    arxiu.close();
  }
  
}

void llegeixFitxerBED(string f, dimint ni, dimint ns)
{
  ifstream arxiu;
  unsigned char * header;
  unsigned char * memblock;
  int r, SNPmajor;
  dimint nrf, resta, inc;

  r = comprovaExistenciaFitxer(f);
  if(r == 0)
  {
    arxiu.open(f.c_str(),ios::binary);
    
    //Llegint la capçalera del fitxer.
    
    header=new unsigned char [3];
    arxiu.read((char*)( &header[0]), 3);
    
    if(header[0] != 0x6C || header[1]!=0x1B)
    {
      escriuError("Error: The data file is not a valid binary BED > v1.0");
    }
    
    if(header[2]==0x1)
    {
      SNPmajor = 1;
      nrf = ni/4;
      resta = ni%4;
      if(((nrf*4)+resta)!=ni)
      {
        escriuError("Error: An internal error ocurred.");
      }
      std::cout << "Reading the binary file in SNP-major mode." << std::endl;
    }
    else if(header[2]==0x0)
    {
      SNPmajor = 0;
      nrf = ns/4;
      resta = ns%4;
      if(((nrf*4)+resta)!=ns)
      {
        escriuError("Error: An internal error ocurred.");
      }
      std::cout << "Reading the binary file in Individual-major mode." << std::endl;
    }
    else
    {
      SNPmajor = 0;
      nrf = 0;
      resta = 0;
      escriuError("Error: The data file is not a valid binary BED.\nIt is not specified whether the file is in SNP-major o Individual-major mode.");
    }
    delete [] header;
    
    //Llegint les dades deol fitxer.
    inc=0;
    if(resta!=0)
    {
      inc = 1;
    }
    memblock=new unsigned char [nrf + 1]; //Guarda +1 per tindre en compte totes les possibles situacions.
    if(memblock!=NULL)
    {
      if(SNPmajor==1) //SNP-major mode.
      {
        for(dimint i=0; i<ns; i++)
        //for(dimint i=0; i<1; i++)
        {
          arxiu.read((char*)(&memblock[0]), nrf + inc); //S'ha de llegir un tros més en funció de si hi ha resta o no.
          for(dimint j=0; j<nrf; j++)
          {
//std::cout << j << std::endl; std::cout.flush();            
            msnps[i].introdueixGenotipsBinaris(memblock[j], 4, 0);
//fprintf(test, BYTETOBINARYPATTERN" "BYTETOBINARYPATTERN"\n",  BYTETOBINARY(temp1), BYTETOBINARY(temp2));
//fprintf(test, BYTETOBINARYPATTERN"\n",  BYTETOBINARY(memblock[j]));
          }
          msnps[i].introdueixGenotipsBinaris(memblock[nrf], resta, 0);
        }
      }
      else //Individual-major mode.
      {
        for(dimint i=0; i<ni; i++)
        {
          arxiu.read((char*)(&memblock[0]), nrf + inc);
          for(dimint j=0; j<nrf; j++)
          {
            for(dimint k=0; k<4; k++)
            {
              msnps[j*4 + k].introdueixGenotipsBinaris(memblock[j], 1, k*2);
            }
          }
          for(dimint k=0; k<resta; k++)
          {
            msnps[nrf*4 + k].introdueixGenotipsBinaris(memblock[nrf], 1, k*2);
          }
        }
      }
    }
    else
    {
      escriuError("Error: There are not enough memory for reading the binary file.");
    }
    delete [] memblock;
    
    arxiu.close();
  }
        
}

void llegeixFitxerBIM(string f, dimint ns)
{
  ifstream arxiu;
  string temp[6];
  char c1,c2;
  int r;
 
  r = comprovaExistenciaFitxer(f);
  if(r == 0)
  {
    arxiu.open(f.c_str());
    for(dimint i=0; i<ns; i++)
    {
      arxiu >> temp[0] >> temp[1] >> temp[2] >> temp[3] >> temp[4] >> temp[5];
      msnps[i].nom = temp[1];
      c1 = msnps[i].comprovaExisteixAllel(temp[4]);
      c2 = msnps[i].comprovaExisteixAllel(temp[5]);
      if(msnps[i].a[0] == ' ' || msnps[i].a[1] == ' ')
      {
        escriuError("Error. The format of one or more allels is not correct.");
      }
    }
    arxiu.close();
  }
  
}

void llegeixFitxerFAM(string f, dimint ni)
{
  ifstream arxiu;
  string temp;
  int r;

  r = comprovaExistenciaFitxer(f);
  if(r == 0)
  {
    arxiu.open(f.c_str());
    for(dimint i=0; i<ni; i++)
    {
      arxiu >> mindividus[i].familyID;
      arxiu >> mindividus[i].individualID;
      arxiu >> mindividus[i].paternalID;
      arxiu >> mindividus[i].maternalID;
      arxiu >> mindividus[i].sex;
      arxiu >> temp;
      stringstream ss(temp);
      if( (ss >> mindividus[i].phenotype).fail() )
      {
        escriuError("Error. The phenotype of the individual " + mindividus[i].familyID + " " + mindividus[i].individualID + " is not an integer: " + temp);
      }
    }
    arxiu.close();
  }
}

dimint contaNLinies(string f)
{
  ifstream arxiu;
  int r;
  dimint nlines=0;
  string str;
  
  r = comprovaExistenciaFitxer(f);
  if(r == 0)
  {
    arxiu.open(f.c_str());
    while(getline(arxiu,str))
    {
      nlines++;
    }
    arxiu.close();
  }
  
  return nlines;
}
