#include "interaccio.h"

void calcula_interaccions(string f, double llindar, int pid, int np)
{
  float temptaula[4][4][4];
  double stat;
  double ptemp;
  double sqrtptemp;
  double stemp;
  double llindarc;
  ofstream fresults;
  double alfatemp;
  double tncasos, tncontrols;
  string filetemp;
  boost::math::chi_squared dist(4);
  unsigned int npm5;

  #ifdef USEMPI
  stringstream ss;
  ss << pid;
  filetemp=f+".pid."+ss.str();
  #else
  filetemp=f;
  #endif
 
  llindarc = llindar/alfa;
  fresults.open(filetemp.c_str(),ios::out);
  fresults << "SNP1" << " " << "SNP2" << " " << "P" << " " << "EV<5" << std::endl;
  
  for(dimint is1=pid; is1<nsnps; is1+=np)
  {
    for(dimint is2=is1+1; is2<nsnps; is2++)
    {

      for(int i=0; i<4; i++)
      {
        for(int j=0; j<4; j++)
        {
          temptaula[1][i][j]=0.;
          temptaula[2][i][j]=0.;
        }
      }
      
      for(dimint ii=0; ii<nindividus; ii++)
      {
        temptaula[mfenotips[ii]][mgenotips[is1].genotips[ii]][mgenotips[is2].genotips[ii]] = temptaula[mfenotips[ii]][mgenotips[is1].genotips[ii]][mgenotips[is2].genotips[ii]] + 1.;
      }

      tncasos = (msnps[is1].ncasos<msnps[is2].ncasos?msnps[is1].ncasos:msnps[is2].ncasos);
      tncontrols = (msnps[is1].ncontrols<msnps[is2].ncontrols?msnps[is1].ncontrols:msnps[is2].ncontrols);

      stat = 0.;
      for(int i=1; i<4; i++)
      {
        for(int j=1; j<4; j++)
        {
          ptemp = pesperadescontrols[is1].p[i]*pesperadescontrols[is2].p[j];
          sqrtptemp = sqrtpesperadescontrols[is1].p[i]*sqrtpesperadescontrols[is2].p[j];
          stemp = (((temptaula[1][i][j]/tncontrols)-ptemp)/sqrtptemp);
          
          ptemp = pesperadescasos[is1].p[i]*pesperadescasos[is2].p[j];
          sqrtptemp = sqrtpesperadescasos[is1].p[i]*sqrtpesperadescasos[is2].p[j];
          stemp = stemp - (((temptaula[2][i][j]/tncasos)-ptemp)/sqrtptemp);
          stat = stat + (stemp*stemp);
        }
      }
      
      if(stat > llindarc)
      {
        if(!isinf(stat))
        {
          npm5 = 0;
          for(int i=1; i<4; i++)
          {
            for(int j=1; j<4; j++)
            {
              ptemp = (5. > (pesperadescontrols[is1].p[i]*pesperadescontrols[is2].p[j]*tncontrols)?1:0);
              npm5 = npm5 + ptemp;
              ptemp = (5. > (pesperadescasos[is1].p[i]*pesperadescasos[is2].p[j]*tncasos)?1:0);
              npm5 = npm5 + ptemp;
            }
          }
          alfatemp=1./((1./tncasos)+(1./tncontrols));
          fresults << msnps[is1].nom << " " << msnps[is2].nom << " " << boost::math::cdf(boost::math::complement(dist,stat*alfatemp)) << " " << npm5 << std::endl;
        }
      }
     
    }
  }
  
  fresults.close();
}
