#include "main.h"

individu *mindividus;
dimint nindividus;
int *mfenotips;

snp *msnps;
genotip *mgenotips;
dimint nsnps;

pgenotip *pesperadescasos;
pgenotip *pesperadescontrols;
pgenotip *sqrtpesperadescasos;
pgenotip *sqrtpesperadescontrols;

double ncasos;
double ncontrols;
double alfa;

int main(int argc, char* argv[])
{
  string f;
  opcions o;
  int pid, np;

  #ifdef USEMPI
  if (MPI_Init( &argc, &argv ) != MPI_SUCCESS)
  {
    escriuError("Error: MPI can not be initialized.");
    exit(1);
  }
  MPI_Comm_size ( MPI_COMM_WORLD, &np );
  MPI_Comm_rank ( MPI_COMM_WORLD, &pid );
  #else
  pid=0;
  np=1;
  #endif
  
  escriuCapcalera();
  
  //Comprovar tamany char!!!;
  
  //Agafa els flags amb els que s'executa el programa
  
  o.setDefaults();
  o.agafaOpcions(argc, argv);
  
  //Obté el número d'individus total i el número d'snps
  
  if(o.binary==0)
  {
    f = o.f_IN;
    f += ".map";
    nsnps = contaNLinies(f);
    f = o.f_IN;
    f += ".ped";
    nindividus = contaNLinies(f);
  }
  else{
    f = o.f_IN;
    f += ".bim";
    nsnps = contaNLinies(f);
    f = o.f_IN;
    f += ".fam";
    nindividus = contaNLinies(f);
  }
  
  //Crea les matrius i classes que s'utilitzaran per la simulació
  
  mindividus = new individu[nindividus];
  mfenotips = new int[nindividus];
  msnps = new snp[nsnps];
  mgenotips = new genotip[nsnps];
  for(dimint i=0; i<nsnps; i++)
  {
    msnps[i].reservaMemoria(nindividus);
    mgenotips[i].reservaMemoria(nindividus);
  }
  pesperadescasos = new pgenotip[nsnps];
  pesperadescontrols = new pgenotip[nsnps];
  sqrtpesperadescasos = new pgenotip[nsnps];
  sqrtpesperadescontrols = new pgenotip[nsnps];
  
  //Llegeix les dades

  if(o.binary==0)
  {
    f = o.f_IN;
    f += ".map";
    std::cout << "Reading [ " << f << " ]..." << std::endl;
    llegeixFitxerMAP(f, nsnps);
  
    f = o.f_IN;
    f += ".ped";
    std::cout << "Reading [ " << f << " ]..." << std::endl;
    llegeixFitxerPED(f, nindividus, nsnps);
  }
  else
  {
    f = o.f_IN;
    f += ".bim";
    std::cout << "Reading [ " << f << " ]..." << std::endl;
    llegeixFitxerBIM(f, nsnps);
    
    f = o.f_IN;
    f += ".fam";
    std::cout << "Reading [ " << f << " ]..." << std::endl;
    llegeixFitxerFAM(f, nindividus);
  
    f = o.f_IN;
    f += ".bed";
    std::cout << "Reading [ " << f << " ]..." << std::endl;
    llegeixFitxerBED(f, nindividus, nsnps); 
    //f = "prova.ped";
    //llegeixFitxerPED(f, nindividus, nsnps);
  }
  
  std::cout << "Data reading has been completed." << std::endl;
  std::cout << nsnps << " SNPs has been read." << std::endl;
  std::cout << nindividus << " individus has been read." << std::endl;
  
  //Calcula variables necessaries per la simulació.
  
  for(dimint i=0; i<nsnps; i++)
  {
    msnps[i].calculapEsperada();
    for(int j=0; j<4; j++)
    {
      pesperadescasos[i].p[j]=msnps[i].pesperatcasos.p[j];
      pesperadescontrols[i].p[j]=msnps[i].pesperatcontrols.p[j];
      sqrtpesperadescasos[i].p[j]=sqrt(msnps[i].pesperatcasos.p[j]);
      sqrtpesperadescontrols[i].p[j]=sqrt(msnps[i].pesperatcontrols.p[j]);
    }
    mgenotips[i].afegeixDades(i, nindividus);
  }

  ncasos=0.;
  ncontrols=0.;
  for(dimint i=0; i<nindividus; i++)
  {
    if(mindividus[i].phenotype==1)
    {
      ncontrols=ncontrols+1.;
      mfenotips[i] = mindividus[i].phenotype;
    }
    else if(mindividus[i].phenotype==2)
    {
      ncasos=ncasos+1;
      mfenotips[i] = mindividus[i].phenotype;
    }
    else
    {
      mfenotips[i] = 0;
    }
  }
  alfa=1./((1./ncasos)+(1./ncontrols));
  
  //Inicia la simulació
  
  std::cout << "Starting the calculation..." << std::endl;
  calcula_interaccions(o.f_OUT, o.quantilsignificancia, pid, np);
  
  //Allibera memòria
  
  for(dimint i=0; i<nsnps; i++)
  {
    msnps[i].alliberaMemoria();
    mgenotips[i].alliberaMemoria();
  }
  delete [] mindividus;
  delete [] mfenotips;
  delete [] msnps;
  delete [] mgenotips;
  delete [] pesperadescasos;
  delete [] pesperadescontrols;
  delete [] sqrtpesperadescasos;
  delete [] sqrtpesperadescontrols;
  
  std::cout << "The calculation is ended." << std::endl;

  #ifdef USEMPI
  MPI_Finalize();
  #endif
  
  return 0;
}

  /*for(dimint i=0; i<nsnps; i++)
  {
    msnps[i].escriuInfoSNP();
  }*/
