#ifndef MAIN_H
#define MAIN_H

#include <iostream>
#include <fstream>
#include <sstream>
#include <limits>
#include <string>
#include <cstdlib>
#include <cmath>
#include <cstring>
#include <cstdio>
#include <boost/math/distributions/chi_squared.hpp>
#ifdef USEMPI
#include "mpi.h"
#endif

#define BYTETOBINARYPATTERN "%d%d%d%d%d%d%d%d"
#define BYTETOBINARY(byte)  \
  (byte & 0x80 ? 1 : 0), \
  (byte & 0x40 ? 1 : 0), \
  (byte & 0x20 ? 1 : 0), \
  (byte & 0x10 ? 1 : 0), \
  (byte & 0x08 ? 1 : 0), \
  (byte & 0x04 ? 1 : 0), \
  (byte & 0x02 ? 1 : 0), \
  (byte & 0x01 ? 1 : 0) 

using namespace std;

typedef unsigned int dimint;

struct pgenotip
{
  double p[4];
};

#include "individu.h"
#include "snp.h"
#include "misc.h"
#include "input.h"
#include "interaccio.h"

class individu;
class snp;
class genotip;
class opcions;

extern individu *mindividus;
extern dimint nindividus;
extern int *mfenotips;

extern snp *msnps;
extern genotip *mgenotips;
extern dimint nsnps;

extern pgenotip *pesperadescasos;
extern pgenotip *pesperadescontrols;
extern pgenotip *sqrtpesperadescasos;
extern pgenotip *sqrtpesperadescontrols;


extern double ncasos;
extern double ncontrols;
extern double alfa;

#endif
