#include "misc.h"

int comprovaExistenciaFitxer(string f)
{
  ifstream test;
  int r;
  
  r = 0;
  test.open(f.c_str(), ifstream::in);
  if(test.fail())
  {
    test.clear(ios::failbit);
    test.close();
    string e = "Error: The file [ " + f + " ] does not exist.";
    escriuError(e);
    r = 1;
  }
  test.close();
  return r;
}

void escriuCapcalera()
{
  std::cout << "----------------------------------------" << std::endl;
  std::cout << "|               2.chi.2                |" << std::endl;
  std::cout << "----------------------------------------" << std::endl;
  std::cout << "2011 GRR, GNU General Public License, v3" << std::endl;
  std::cout << "version: v0.9" << std::endl << std::endl;
}

void escriuError(string e)
{
  std::cout << "**********************************" << std::endl;
  std::cout << e << std::endl;
  std::cout << "**********************************" << std::endl;
  exit(1);
}

void opcions::setDefaults()
{
  f_IN="";
  f_OUT="results.dat";
  //llindarsignificancia=13.2767;
  significancia = 0.01;
  boost::math::chi_squared dist(4);
  quantilsignificancia=boost::math::quantile(boost::math::complement(dist,significancia));
  binary=0;
}

void opcions::agafaOpcions(int argc, char* argv[])
{
  int fi, fo, fs;
  
  fi = 0;
  fo = 0;
  fs = 0;
  
  std::cout << "Options in effect:" << std::endl;
  for (int i = 1; i < argc; i++) 
  {
    if ( !strcmp(argv[i],"--input") )
    {
      if (i + 1 <= argc)
      {
        f_IN.assign(argv[i + 1]);
        std::cout << "\t" << argv[i] << " " << f_IN << std::endl;
        fi = 1;
      }
    }
    else if (!strcmp(argv[i],"--output"))
    {
      if (i + 1 <= argc)
      {
        f_OUT.assign(argv[i + 1]);
        std::cout << "\t" << argv[i] << " " << f_OUT << std::endl;
        fo = 1;
      }
    }
    else if (!strcmp(argv[i],"--threshold"))
    {
      if (i + 1 <= argc)
      {
        stringstream ss(argv[i + 1]);
        if( (ss >> significancia).fail() )
        {
          escriuError("Error: The threshold is not a valid number. It must be a number between 0 and 1.\nScientific notation can be used (e.g. 1e-2).");
        }
        if( significancia < 0. )
        {
          escriuError("Error: The threshold is not a valid number. It must be a number between 0 and 1.\nScientific notation can be used (e.g. 1e-2).");
        }
        boost::math::chi_squared dist(4);
        quantilsignificancia = boost::math::quantile(boost::math::complement(dist,significancia));
        std::cout << "\t" << argv[i] << " " << significancia << " (q:" << quantilsignificancia << ")"<< std::endl;
        fs = 1;
      }
    }
    else if ( !strcmp(argv[i],"--b") )
    {
      binary=1;
      std::cout << "\t" << argv[i] << std::endl;
    }
    else
    {
      if(!strncmp(argv[i],"--",2))
      {
        std::cout << "\t" << argv[i] << " is not a valid option. It will be ignored." << std::endl;
      }
    }
  }
  
  if(fi == 0)
  {
    escriuError("Error: No input file is specified. Please, use the option --input to specify the input file.");
  }
  if(fo == 0)
  {
    std::cout << "No output file specified. Using the default [ results.dat ]" << std::endl;
  }
  if(fs == 0)
  {
    std::cout << "No significance threshold specified. Using the default value: " << significancia << " (q:" << quantilsignificancia << ")" << std::endl;
  }
}
