#include "snp.h"

int genotip::reservaMemoria(dimint ni)
{
  int r;
  
  genotips = new unsigned char[ni];
  
  r = 0;
  if(genotips == NULL)
  {
    r = 1;
    escriuError("Error: Not enough memory to load the SNP data into memory.");
  }
  
  return r;
}

void genotip::alliberaMemoria()
{
  delete [] genotips;
}

void genotip::afegeixDades(dimint is, dimint ni)
{
  if(ni!=msnps[is].ngenotips)
  {
    escriuError("Error: There is an individual with a number of genotypes different than expected.");
  }
  for(dimint i=0; i<ni; i++)
  {
    genotips[i]=msnps[is].genotips[i];
  }
}

int snp::reservaMemoria(dimint ni)
{
  int r;
  
  a[0] = ' ';
  a[1] = ' ';
  ple = 0;
  
  na[0] = 0;
  na[1] = 0;
  
  /*ia[0] = new dimint [ni];
  ia[1] = new dimint [ni];*/
  
  genotips = new unsigned char [ni];
  ngenotips = 0;
  
  r = 0;
  if(genotips == NULL)
  {
    r = 1;
    escriuError("Error: Not enough memory to load the genotypic data.");
  }
  
  return r;
}

void snp::alliberaMemoria()
{
  delete [] genotips;
}

char snp::comprovaExisteixAllel(string at)
{
  char c;
  
  if(at.length() == 1)
  {
    c = *at.data();
    if(c != '0')
    {
      if(a[0] == ' ')
      {
        a[0] = c;
      }
      else if(a[1] == ' ' && a[0] != c)
      {
        a[1] = c;
      }
    }
  }
  else
  {
    c = '0';
    escriuError("Error: A genotype defined by more than one character is found.");
  }
  
  return c;
}

void snp::introdueixGenotips(string a1, string a2)
{
  //int tm = 0;
  //int ta1, ta2;
  char c1, c2;
  
  
  c1 = comprovaExisteixAllel(a1);
  c2 = comprovaExisteixAllel(a2);
  
  if(c1 != '0' && c2 != '0')
  {
    if(c1 == a[0] && c2 == a[0])
    {
      genotips[ngenotips] = 1;
      ngenotips++;
    }
    else if(c1 == a[1] && c2 == a[1])
    {
      genotips[ngenotips] = 3;
      ngenotips++;
    }
    else if(c1 == a[0] && c2 == a[1])
    {
      genotips[ngenotips] = 2;
      ngenotips++;
    }
    else if(c1 == a[1] && c2 == a[0])
    {
      genotips[ngenotips] = 2;
      ngenotips++;
    }
    else
    {
      escriuError("Error: An individual with more than two allel types is found.");
    }
  }
  else
  {
    genotips[ngenotips] = 0;
    ngenotips++;
  }
}

void snp::introdueixGenotipsBinaris(unsigned char g, dimint n, dimint d)
{
  unsigned char temp1, temp2;
  
  temp1 = g;
  temp1 = temp1 >> d;
  
  for(dimint i=0; i<n; i++)
  {
    temp2 = temp1 & 0x3;
    if( temp2 == 0x0 )  //homozigot
    {
      genotips[ngenotips] = 3;
    }
    else if( temp2 == 0x3 ) //homozigot
    {
      genotips[ngenotips] = 1;
    }
    else if( temp2 == 0x2 ) //heterozigot
    {
      genotips[ngenotips] = 2;
    }
    else if( temp2 == 0x1 ) //nul
    {
      genotips[ngenotips] = 0;
    }
    else
    {
      escriuError("Error: An error happened when reading the binary file.");
    }
//fprintf(test, BYTETOBINARYPATTERN" "BYTETOBINARYPATTERN" %d %d\n",  BYTETOBINARY(temp1), BYTETOBINARY(temp2),ngenotips,genotips[ngenotips]);
    ngenotips++;
    temp1 = temp1 >> 2;
  }
}

void snp::calculapEsperada()
{
  int temp;
  
  if(nindividus!=ngenotips)
  {
    escriuError("Error: There is an individual with a number of genotypes different than expected.");
  }
  
  ncasos=0.;
  ncontrols=0.;
  for(int i=0; i<4; i++)
  {
    pesperatcasos.p[i]=0.;
    pesperatcontrols.p[i]=0.;
  }

  for(dimint i=0; i<ngenotips; i++)
  {
    temp = (int)genotips[i];
    if(mindividus[i].phenotype==2)
    {
      pesperatcasos.p[temp]=pesperatcasos.p[temp] + 1.;
      if(temp!=0)
      {
        ncasos=ncasos+1.;
      }
    }
    else if(mindividus[i].phenotype==1)
    {
      pesperatcontrols.p[temp]=pesperatcontrols.p[temp] + 1.;
      if(temp!=0)
      {
        ncontrols=ncontrols+1.;
      }
    }
  }
  
  for(int i=0; i<4; i++)
  {
    pesperatcasos.p[i]=pesperatcasos.p[i]/ncasos;
    pesperatcontrols.p[i]=pesperatcontrols.p[i]/ncontrols;
  }
}

void snp::escriuInfoSNP()
{
  ofstream test;
  
  //test.open("test2.dat");
  std::cout << nom << " (" << ngenotips << "): " << a[0] << " " << a[1] << std::endl;
  /*for (dimint i=0; i<ngenotips; i++)
  {
    //printf("%d\n",genotips[i]);
    if(genotips[i]==1)
    {
      test << "C C" << std::endl;
    }
    else if(genotips[i]==3)
    {
      test << "A A" << std::endl;
    }
    else if(genotips[i]==2)
    {
      test << "C A" << std::endl;
    }
    else if(genotips[i]==0)
    {
      test << "0 0" << std::endl;
    }
    else
    {
      test << "Error" << std::endl;
      escriuError("Error.");
    }
  }
  test.close();*/
  std::cout << "Frequencies genotipiques casos: 1:" << pesperatcasos.p[1] << " 2:" << pesperatcasos.p[2] << " 3:" << pesperatcasos.p[3] << " N: " << pesperatcasos.p[0] << std::endl;
  std::cout << "Frequencies genotipiques controls: 1:" << pesperatcontrols.p[1] << " 2:" << pesperatcontrols.p[2] << " 3:" << pesperatcontrols.p[3] << " N: " << pesperatcasos.p[0] << std::endl;
}

