close all; clear all;
matlabpath([pathdef,'../focus;','../export_fig;','../identification']);
%% FOCUS ANALYSIS
parameters = focus_parameters;
parameters.id = 'urine_demo';
parameters.peak.pT = [2 1e-3];
results = focus_workflow('demo_int.txt','demo_ppm.txt','demo_samples.txt',parameters,[]);
%% EXPORT PEAK DATA (INFO & INTENSITIES)
data = export_peaks(results,1,1);
%% COMPOUND IDENTIFICATION
% create reference library
S{1}.name = 'citrate-7.0';
S{1}.spect=[[2.674 75853720];[2.649 110800152];[2.550 113938640];[2.525 77852232]];
% identification
data = peak_identification(results,S,0.05,0.03,0.005,[0.85 0.85],1);