function [Xp,X2p,dt] = fineshift(X,X2)
%fineshif - Fine alignment of spectral signals
%
% Syntax:  [Xp, X2p, dt] = fineshift(X,X2)
%
% Inputs:
%  - X: Matrix containing signals column-wise.
%  - X2: Matrix containing transformed signals column-wise.
%
% Outputs:
%  - X: Matrix containing aligned signals column-wise.
%  - X2: Matrix containing aligned transformed signals column-wise.
%  - dt: Shifts applied to each sample
%
% Author:  Arnald Alonso - Rheumatology Research Group (VHIR)
% email:   arnald.alonso@vhir.org
% Website: http://www.urr.cat
% June 2013; Last revision: 01-June-2013

%------------- BEGIN CODE --------------
[Np, Ns] = size(X);
dt    = zeros(2,Ns); 
fft_e = 2^ceil(log2(Np)+1);
LF    = round(fft_e/128);
X     = [mean(X,2) X];
FX2   = fft(X,fft_e); 
EN    = sqrt(sum(X.^2)); 
pm    = fft_e*0.5+1;
for i=2:Ns+1, 
    j = 1;
    c = circshift(ifft(FX2(:,i).*conj(FX2(:,j)),fft_e),fft_e/2).*gausswin(fft_e,2)/(EN(i)*EN(j));
    if LF>3, c = filtfilt(ones(1,LF)/LF,1,c); end
    dc        = diff(c);
    ddc       = diff(dc);
    iR        = find(diff(sign(ddc(pm:end)))==2)+pm-1;
    iL        = find(diff(sign(ddc(1:pm)))==-2);
    if ~isempty(iR) && ~isempty(iL),
        iR        = iR(1);
        iL        = iL(end);
        [M,iM]=max(c(iL:iR));
        iM  = iM+iL-1;
        dt(1,i-1) = M/c(pm);
        dt(2,i-1) = iM-pm;
    end
end
X  = X(:,2:end);
Xp = X;
X2p= X2;
for i=1:Ns,
    if dt(2,i)>0,     
        X2p(1:(Np-3-dt(2,i)),i)     = X2((dt(2,i)+1):end,i);
        X2p((Np-3-dt(2,i)+1):end,i) = 0;
        Xp(1:(Np-dt(2,i)),i)      = X((dt(2,i)+1):end,i);
        Xp((Np-dt(2,i)+1):end,i)  = 0;
    elseif dt(2,i)<0, 
        X2p((-dt(2,i)+1):end,i)   = X2(1:(end+dt(2,i)),i);
        X2p(1:(-dt(2,i)),i)       = 0;
        Xp((-dt(2,i)+1):end,i)    = X(1:(end+dt(2,i)),i);
        Xp(1:(-dt(2,i)),i)        = 0;
    end
end
dt = dt(2,:);