function parameters = focus_parameters
%FOCUS_PARAMETERS - Creates array structure with FOCUS default parameters
%This function creates an array structure with default parameters to be used 
%as input for the focus_workflow function.
%
% Syntax:  parameters = focus_parameters
%
% Outputs:
%    Array structure with the following fields:
%    - id: Analysis identification name
%    - figures: Figure handles
%    - roi.it: Intensity threshold
%    - roi.min_sample_percent: Minimum sample frequency having intensity values above the 
%      intensity threshold within a spectral point to consider it for a region of interest
%      or for analyzing a window
%    - roi.min_width: Minimum spectral width of consecutive data points that
%      meet the previous requirements to define a point of interest
%    - roi.min_segment_percent: A spectral window is analyzed if a minimum
%      percentage of its spectral points ara points of interest
%    - window.fs: Downsampling frequency (fs >= 1)
%    - window.length: Analysis window length (ppm)
%    - window.ovlap: Consecutive analysis windows overlap (0 < ovlap < 1)
%    - align.LW: Moving average filter length for IWSS computation (ppms)
%    - align.DR: Dynamic range of the resulting IWSS signals
%    - align.SIT: Signal intensity threshold below which is considered as noise
%    - align.TWR: Tukey window ratio of taper to constant sections (if
%      negative no windowing applied)
%    - align.corr_GW: Alpha value for the Gaussian window applied to the convolution signals
%    - align.corr_min: Minimum correlation threshold for a sample to be aligned
%    - align.maxiter: Maximum number of iterations
%    - peak.DFL: Derivative filter length (ppm)
%    - peak.pT: pT(1)=1 refers to minimum increment ratio and pT(1)=2 
%      minimum peak increment to consider a peak. pT(2) is the value.
%    - peak.pS: Peak sample frequency within a spectral region to consider a peak on the dataset
%    - peak.pW: Minimum peak width (ppm) allowed
%    - pr:Minimum overlap to consider two peaks of consecutive windows as the same
%
% See also: focus_workflow

% Author:  Arnald Alonso - Rheumatology Research Group (VHIR)
% email:   arnald.alonso@vhir.org
% Website: http://www.urr.cat
% June 2013; Last revision: 01-June-2013
%------------- BEGIN CODE --------------
%% GENERAL
parameters.id= 'results';
parameters.figures = [1 2 3 4];
%% SPECTRAL POINTS OF INTEREST
parameters.roi.it = 0;
parameters.roi.min_sample_percent = 0.05;
parameters.roi.min_width = 1.4e-3;
parameters.roi.min_segment_percent = 0.05;
%% SPECTRAL WINDOWS
parameters.window.fs     = 1;
parameters.window.length = 0.0769;
parameters.window.ovlap  = 0.5;
%% WINDOW ALIGNMENT
parameters.align.LW = 2.5e-3;
parameters.align.DR  = 10;
parameters.align.SIT = 1e-5;
parameters.align.TWR= 0.4;
parameters.align.corr_GW = 2.5;
parameters.align.corr_min = 0.4;
parameters.align.maxiter = 50;
%% PEAK DETECTION
parameters.peak.DFL = 10e-3;
parameters.peak.pT = [1 1.05];
parameters.peak.pS = 0.10;
parameters.peak.pW = 1e-3;
%% PEAK REDUCTION
parameters.pr = 0.5;
