function X = iwss(X, LW, DR, SIT, TWR)
%iwss - Intensity Weighted Slope Signal Transform
%This function transforms NMR spectral signal to its corresponding intensity
%weighted slope (derivative) signal.
%
% Syntax:  X = iwss(X, LW, DR, SIT, TWR)
%
% Inputs:
%  - X: Matrix containing spectral signals column-wise.
%  - LW: Moving average filter length.
%  - DR: Dynamic range of the resulting signals.
%  - SIT: Signal intensity threshold below which is considered as noise.
%  - TWR: Tukey window ratio of taper to constant sections.
%
% Outputs:
%  - X: Matrix containing transformed spectral signals column-wise.
%
% Author:  Arnald Alonso - Rheumatology Research Group (VHIR)
% email:   arnald.alonso@vhir.org
% Website: http://www.urr.cat
% June 2013; Last revision: 01-June-2013

%------------- BEGIN CODE --------------
if TWR > 0, X = X.*(tukeywin(size(X,1),TWR)*ones(1,size(X,2))); end
if LW>2, 
    Xf  = diff(filtfilt(ones(1,LW)/LW,1,X)); 
else
    Xf  = diff(X);
end
X2  = (Xf > 0) - (Xf < 0);
Ns  = size(X,2);
for i = 1:Ns,
    Y = prctile(X(:, i), linspace(0, 100, DR+1));
    j = find(X2(:, i) == 0);
    temp   = find(X2(:, i) ~= 0);
    if (~isempty(temp)),
        for k = 1:length(j),
            [ ~ , tt ]    = min(abs(j(k) - temp));
            X2(j(k), i) = mean(X2(temp(tt), i));
        end
    end
    for p = 1:(length(Y)-1),
        pp        = (X(2:end, i) >= Y(p))&(X(2:end, i) < Y(p+1));
        X2(pp,i)  = X2(pp, i) * p / ((length(Y) - 1));
    end
end
X2(X(2:end,:)<SIT) = 0;
if ceil(LW*0.5)>2,
    X = filtfilt(2*ones(1,ceil(LW*0.5))/LW,1,X2);
else
    X = X2;
end
%------------- END CODE --------------