function [maxC, ddp, C] = optshift(X,GW)
%optshift - Maximal correlation matrix and optimal distance matrix
%This function computes maximal correlation matrix and optimal distance
%matrix.
%
% Syntax:  [maxC, ddp, C] = optshift(X,GW)
%
% Inputs:
%  - X:  Matrix containing signals column-wise.
%  - GW: Alpha for the Gaussian window applied to the convolution signals.
%
% Outputs:
%  - maxC: Maximal correlation matrix.
%  - ddp:  Optimal distance matrix.
%  - C:    Current correlation matrix.
%
% Author:  Arnald Alonso - Rheumatology Research Group (VHIR)
% email:   arnald.alonso@vhir.org
% Website: http://www.urr.cat
% June 2013; Last revision: 01-June-2013

%------------- BEGIN CODE --------------
[Np, Ns] = size(X);
maxC     = zeros(Ns,Ns); 
C        = zeros(Ns,Ns); 
ddp      = zeros(Ns,Ns); 
fft_e    = 2^ceil(log2(Np)+1);
FX       = fft(X,fft_e); 
EN       = sqrt(sum(X.^2));
for i = 1:Ns, 
    for j = (i+1):Ns,
        if EN(i)*EN(j) ~= 0,
            c         = circshift(ifft(FX(:,i).*conj(FX(:,j)),fft_e),fft_e/2).*gausswin(fft_e,GW)/(EN(i)*EN(j));
            [k,p]     = max(c);
            maxC(i,j) = k;
            maxC(j,i) = maxC(i,j);
            C(i,j)    = c(fft_e * 0.5 + 1); 
            C(j,i)    = C(i,j);
            ddp(i,j)  = p - fft_e*0.5-1;
            ddp(j,i)  = - ddp(i,j);
        end
    end
end
%------------- END CODE --------------