function [ris, f, lim_left, lim_right, center]  = peak_extraction(X,ppm,DFL,pS,pW,pT,figs)
%peak_extraction2 - Peak detection
%
% Syntax:  [X, X2, dt, step] = peak_extraction(X, X2, ddp, maxC, MAX_step, min_corr)
%
% Inputs:
%  - X:    Matrix containing signals column-wise.
%  - ppm:  ppm values corresponding to X rows.
%  - DFL:  Derivative filter length (ppm).
%  - pS:   Peak sample frequency within a spectral region to consider a peak on the dataset
%  - pW:   Minimum peak width (ppm) allowed
%  - pI:   If pT<=0, minimum increment to consider a peak is set as pI
%          times the minimum intensity difference
%  - pT:   Minimum increment to consider a peak
%  - figs: Figure handle
%
%
% Author:  Arnald Alonso - Rheumatology Research Group (VHIR)
% email:   arnald.alonso@vhir.org
% Website: http://www.urr.cat
% June 2013; Last revision: 01-June-2013

%------------- BEGIN CODE --------------
L  = round(DFL/abs(ppm(1)-ppm(2)));      % derivative filter length (n)
TS = zeros(size(ppm));                  % averaged peak positions signal
if figs>0, figure(figs); end
for i=1:size(X,2),
    [Np, ~] = size(X);
    Xi = X(((Np/3)+1):(2*(Np/3)+1),i);
    Xi = Xi(2:end);
    if figs>0, subplot(211);plot(ppm,Xi,'k-'); hold on; end
    f        = - filter( diff(diff(gausswin(L,5))) , sum(abs(diff(diff(gausswin(L,5))))), Xi); 
    f        = [f((ceil(L/2)-2):end);f(end)*ones((ceil(L/2)-2)-1,1)];
    lims     = diff(f>0);
    s = 1;
    n = [0 0];
    segments = zeros(size(Xi));
    for k=1:length(lims),
        if lims(k)==s,
            if s==1,
                n(1)= k;
                s = -1;
            else
                n(2)= k;
                s = 1;
                if pT(1)==2,
                    if (max(Xi(n(1):n(2)))-min(Xi(n(1)),Xi(n(2))) >= pT(2))&&(abs(ppm(n(1))-ppm(n(2)))>pW),
                       segments(n(1):n(2)) = 1;
                       plot(ppm(n(1):n(2)),max(Xi(n(1):n(2)))*ones(1,length(n(1):n(2))),'r-','LineWidth',2);
                    end
                else
                    if (max(Xi(n(1):n(2)))/max(Xi(n(1)),Xi(n(2))))>pT(2) &&(abs(ppm(n(1))-ppm(n(2)))>pW),
                       segments(n(1):n(2)) = 1;
                       plot(ppm(n(1):n(2)),max(Xi(n(1):n(2)))*ones(1,length(n(1):n(2))),'r-','LineWidth',2);
                    end                    
                end
                %end
            end
        end
    end
    if figs>0,
        plot(ppm,f,'r-');grid on;
    end
    TS  = TS + segments;
end
TS = TS/size(X,2);
TS2 = filtfilt(ones(1,round(L/4))/round(L/4),1,TS);
if figs>0, 
    axis tight; grid on; xlabel('ppm'); ylabel('intensity'); title('PER-SAMPLE PEAK DETECTION'); 
    subplot(212);plot(ppm,TS,'k-'); hold on; plot(ppm,TS2,'b-'); plot(ppm,pS*ones(size(ppm)),'r--');
    axis tight; grid on; xlabel('ppm'); title('CONSENSUS PEAKS');
end
f2   = -filter( diff(diff(gausswin(L,5))) , sum(abs(diff(diff(gausswin(L,5))))), TS2);
f2   = [f2((ceil(L/2)-2):end);f2(end)*ones((ceil(L/2)-2)-1,1)];
lims = diff(f2>0);
s = 1;
n = [0 0];
segments = [];
for k=1:length(lims),
    if lims(k)==s,
        if s==1,
            n(1)= k;
            s = -1;
        else
            n(2)= k;
            s = 1;
            if (max(TS2(n(1):n(2)))>pS)&&(abs(ppm(n(2))-ppm(n(1)))>pW),
                segments = [segments; n];
            end
        end
    end
end
if figs>0,
    for jj=1:size(segments,1), 
        subplot(211); area(ppm(segments(jj,:)),max(X(:))*ones(1,2),'FaceColor','b'); alpha(0.1); 
        subplot(212); area(ppm(segments(jj,:)),max(TS2)*ones(1,2),'FaceColor','r'); alpha(0.2); 
    end
end
segmentsF = zeros(size(segments));
for i=1:size(segments,1),
    dw = abs(diff(segments(i,:)));
    R  = ceil(dw/2);
    if i==size(segments,1),
        M = length(TS2);
    else
        M = segments(i+1,1);
    end
    x  = TS2(segments(i,2):min((segments(i,2)+R),length(TS2)));
    i1 = find(x==0);
    [~,i2] = min(x);
    if ~isempty(i1), i2 = min(min(i1),min(i2)); end
    z = i2(1)+segments(i,2)-1;
    z = min(M,z);
    segmentsF(i,2)=z;
    if i==1,
        M = 1;
    else
        M = segments(i-1,2);
    end
    x  = TS2(max((segments(i,1)-R-1),1):(segments(i,1)));
    i1 = find(x==0);
    [~,i2] = min(x);
    if ~isempty(i1), i2 = max(max(i1),max(i2)); end
    z = segments(i,1)-R+i2(1);
    z = max(M,z);
    segmentsF(i,1)=z;
end
M = mean(segments,2);
K = zeros(size(M));
for i=1:length(K), 
    [~,bb] = max(TS2(segments(i,1):segments(i,2)));
    K(i) = bb+segments(i,1)-1;
end
L = length(TS2)*[0.1 0.9];
i = find((K>=L(1))|(K<=L(2)));
segments = segments(i,:);
segmentsF= segmentsF(i,:);
M        = M(i);
if figs>0,
    for jj=1:size(segmentsF,1), 
        subplot(211); area(ppm(segmentsF(jj,:)),max(X(:))*ones(1,2),'FaceColor','c'); alpha(0.1); 
        subplot(212); area(ppm(segmentsF(jj,:)),max(TS2)*ones(1,2),'FaceColor','m'); alpha(0.2); 
    end
    subplot(211); set(gca,'Xdir','reverse');
    subplot(212); set(gca,'Xdir','reverse');
end
if size(segmentsF,1)>0,
    lim_left  = segmentsF(:,1)';
    lim_right = segmentsF(:,2)';
    center    = round(M)';
else
    lim_left  = [];
    lim_right = [];
    center    = [];
end
ris       = TS2;
f         = TS2;
%------------- END CODE --------------