function results=peak_reduce(results,OT,fig)

Nw = length(results.N_start);
overlap = [];
if Nw>1,
    for iw=2:Nw,
        if sum(results.processed((iw-1):iw))==2,
            shiftA= results.windows{iw}.shift;
            shiftB= results.windows{iw-1}.shift;
            NbegA = results.N_start(iw);
            NbegB = results.N_start(iw-1);
            Na = find(results.peaks_info==iw);
            Nb = find(results.peaks_info==iw-1);
            if ~isempty(Na) && ~isempty(Nb),
                for ia=1:length(Na),
                    for ib=1:length(Nb),
                        PbegA = NbegA+results.peaks{Na(ia)}.start-1;
                        PendA = NbegA+results.peaks{Na(ia)}.end  -1;
                        PbegB = NbegB+results.peaks{Nb(ib)}.start-1;
                        PendB = NbegB+results.peaks{Nb(ib)}.end  -1;
                        ov    = zeros(1,size(results.input.data,2));
                        for j=1:size(results.input.data,2), 
                            jja  = (PbegA:PendA)+shiftA(j);
                            jjb  = (PbegB:PendB)+shiftB(j);
                            ov(j)= min(1,length(intersect(jja,jjb))/min(length(jja),length(jjb)));
                        end
                        ii= find((results.peaks{Na(ia)}.corr>0.1) & (results.peaks{Na(ia)}.corr>0.1));
                        if length(ii)<0.2*length(ov), ii=1:length(ov); end
                        r = (abs(results.peaks{Na(ia)}.areas) + abs(results.peaks{Na(ia)}.areas))/2;
                        t = corrcoef(results.peaks{Na(ia)}.maxs(ii),results.peaks{Nb(ib)}.maxs(ii));
                        x = mean(results.peaks{Na(ia)}.corr) >= mean(results.peaks{Nb(ib)}.corr);
                        if x==1, 
                            overlap = [overlap;[Na(ia) Nb(ib) length(find(ov(ii)>0.2))/length((ii)) t(1,2) mean(ov(ii)) std(ov(ii))]];
                        else
                            overlap = [overlap;[Nb(ib) Na(ia) length(find(ov(ii)>0.2))/length((ii)) t(1,2) mean(ov(ii)) std(ov(ii))]];
                        end
                    end
                end
            end
        end
    end
    if fig>0,
        figure(fig); clf(fig);
        hFig = figure(fig); clf(fig);
        set(hFig, 'Position', [0 0 1200 600]);
        subplot(121); plot(overlap(:,end-1),overlap(:,4),'b.'); 
        hold on; plot([OT OT],[0 1],'r--');
        xlabel('Peak overlap (average accross samples)'); ylabel('Correlation'); 
        xlim([0 1]); ylim([0 1]); grid on; title('PEAK REDUCTION');
        n = 0:0.05:0.95;
        y = zeros(2,length(n));
        for i=1:length(n), y(:,i)=[mean(overlap(overlap(:,end-1)>=n(i),4));std(overlap(overlap(:,end-1)>=n(i),4))]; end
        subplot(122); errorbar(n,y(1,:),y(2,:));
        xlabel('Peak overlap (average accross samples)'); ylabel('Peak area correlation'); 
        xlim([0 1]); ylim([0 1.2]); grid on; title('PEAK PAIRS CORRELATION DEPENDING ON PEAK OVERLAP THRESHOLD');
        export_fig(sprintf('%s/peak_reduction',results.name),'-tif','-m1');
    end
    overlap = overlap(overlap(:,end-1)>=OT,:);
    results.peaksR = cell(1,length(results.peaks));
    k = 1;
    for i=1:length(results.peaks),
        if all(i~=overlap(:,2)), 
            results.peaksR{k} = results.peaks{i};
            results.peaksR{k}.index = i;
            k = k+1;
        end
    end
    k = k-1;
    results.peaksR = results.peaksR(1:k);
else
    results.peaksR = results.peaks;
end

