function varargout = peakexplorer(varargin)
% PEAKEXPLORER M-file for peakexplorer.fig
%      PEAKEXPLORER, by itself, creates a new PEAKEXPLORER or raises the existing
%      singleton*.
%
%      H = PEAKEXPLORER returns the handle to a new PEAKEXPLORER or the handle to
%      the existing singleton*.
%
%      PEAKEXPLORER('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in PEAKEXPLORER.M with the given input arguments.
%
%      PEAKEXPLORER('Property','Value',...) creates a new PEAKEXPLORER or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before peakexplorer_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to peakexplorer_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help peakexplorer

% Last Modified by GUIDE v2.5 27-Aug-2013 10:08:32

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @peakexplorer_OpeningFcn, ...
                   'gui_OutputFcn',  @peakexplorer_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT

% --- Executes just before peakexplorer is made visible.
function peakexplorer_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to peakexplorer (see VARARGIN)

% Choose default command line output for peakexplorer
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% This sets up the initial plot - only do when we are invisible
% so window can get raised using peakexplorer.
if strcmp(get(hObject,'Visible'),'off')
    results = evalin('base','results');
    imshow(sprintf('%s/figures/peak_%d.jpg',results.name,results.peaksR{1}.id),'Parent',handles.axes1);
    imshow(sprintf('%s/figures/peak_window_%d.jpg',results.name,results.peaksR{1}.window),'Parent',handles.axes3);
end

% UIWAIT makes peakexplorer wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = peakexplorer_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;

% --- Executes on button press in pushbutton1.
function pushbutton1_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
results = evalin('base','results');
popup_sel_index = get(handles.popupmenu1, 'Value');
imshow(sprintf('%s/figures/peak_%d.jpg',results.name,results.peaksR{popup_sel_index}.id),'Parent',handles.axes1);
imshow(sprintf('%s/figures/peak_window_%d.jpg',results.name,results.peaksR{popup_sel_index}.window),'Parent',handles.axes3);

% --------------------------------------------------------------------
function FileMenu_Callback(hObject, eventdata, handles)
% hObject    handle to FileMenu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function OpenMenuItem_Callback(hObject, eventdata, handles)
% hObject    handle to OpenMenuItem (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
file = uigetfile('*.fig');
if ~isequal(file, 0)
    open(file);
end

% --------------------------------------------------------------------
function PrintMenuItem_Callback(hObject, eventdata, handles)
% hObject    handle to PrintMenuItem (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
printdlg(handles.figure1)

% --------------------------------------------------------------------
function CloseMenuItem_Callback(hObject, eventdata, handles)
% hObject    handle to CloseMenuItem (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
selection = questdlg(['Close ' get(handles.figure1,'Name') '?'],...
                     ['Close ' get(handles.figure1,'Name') '...'],...
                     'Yes','No','Yes');
if strcmp(selection,'No')
    return;
end

delete(handles.figure1)


% --- Executes on selection change in popupmenu1.
function popupmenu1_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenu1 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu1


% --- Executes during object creation, after setting all properties.
function popupmenu1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
     set(hObject,'BackgroundColor','white');
end
results = evalin('base','results');
speaki = cell(1,length(results.peaksR));
for j=1:length(results.peaksR),
    speaki{j}=sprintf('%d->%1.3f',results.peaksR{j}.id,results.peaksR{j}.ppm); 
end
assignin('base','speaki',i);
set(hObject, 'String', speaki);

function corP_Callback(hObject, eventdata, handles)
% hObject    handle to corP (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of corP as text
%        str2double(get(hObject,'String')) returns contents of corP as a double


% --- Executes during object creation, after setting all properties.
function corP_CreateFcn(hObject, eventdata, handles)
% hObject    handle to corP (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function corT_Callback(hObject, eventdata, handles)
% hObject    handle to corT (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of corT as text
%        str2double(get(hObject,'String')) returns contents of corT as a double


% --- Executes during object creation, after setting all properties.
function corT_CreateFcn(hObject, eventdata, handles)
% hObject    handle to corT (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
set(hObject,'String',0.2);


function incT_Callback(hObject, eventdata, handles)
% hObject    handle to incT (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of incT as text
%        str2double(get(hObject,'String')) returns contents of incT as a double


% --- Executes during object creation, after setting all properties.
function incT_CreateFcn(hObject, eventdata, handles)
% hObject    handle to incT (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
set(hObject,'String',0);

% --- Executes during object creation, after setting all properties.
function pushbutton1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to pushbutton1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called


% --- Executes on slider movement.
function slider1_Callback(hObject, eventdata, handles)
% hObject    handle to slider1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider


% --- Executes during object creation, after setting all properties.
function slider1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to slider1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end
set(hObject, 'Value', 0.9);

% --- Executes during object creation, after setting all properties.
function uipanel2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to uipanel2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called



function ACT_Callback(hObject, eventdata, handles)
% hObject    handle to ACT (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of ACT as text
%        str2double(get(hObject,'String')) returns contents of ACT as a double


% --- Executes during object creation, after setting all properties.
function ACT_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ACT (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
set(hObject, 'String', '0.9');

% --- Executes on button press in pushbutton4.
function pushbutton4_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
results = evalin('base','results');
SICT = str2num(get(handles.corT, 'String'));
SIT  = str2num(get(handles.incT, 'String'));
ACT  = str2num(get(handles.ACT, 'String'));
PER  = str2num(get(handles.PER, 'String'));
ipeak= get(handles.popupmenu1, 'Value');
res  = zeros(length(results.peaksR),3);
for i=1:length(results.peaksR),
    res(i,:) = peak_stocsy_c(results,ipeak,i,SIT,SICT,PER);
end

axes(handles.axes2);

hold off;bar(handles.axes2,res(res(:,3)>-2,2),res(res(:,3)>-2,3)); hold on; grid on; plot(handles.axes2,results.input.ppm,-mean(results.input.data')/prctile(mean(results.input.data'),90),'-'); axis tight; ylim([-1 1]);
plot(handles.axes2,[0 12],ACT*[1 1],'r--','LineWidth',1.5);plot(handles.axes2,ones(1,2)*res(1,1),[-1 1],'r--','LineWidth',1.5); set(gca,'XDir','reverse');
i = find(res(:,3)>ACT);
p = res(res(:,3)>ACT,2);
set(handles.peaklist,'string',p)
set(handles.corrlist,'string',res(res(:,3)>ACT,3))
speak = cell(1,length(i));
for j=1:length(i), speak{j}=sprintf('%d->%1.3f',results.peaksR{i(j)}.id,p(j)); end
assignin('base','speaks',i);
if ~isempty(p),
    set(handles.popupmenu2, 'String', speak);
else
    set(handles.popupmenu2, 'String', 'NA');
end
set(handles.popupmenu2, 'Value', 1);

function PER_Callback(hObject, eventdata, handles)
% hObject    handle to PER (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of PER as text
%        str2double(get(hObject,'String')) returns contents of PER as a double


% --- Executes during object creation, after setting all properties.
function PER_CreateFcn(hObject, eventdata, handles)
% hObject    handle to PER (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
set(hObject, 'String', '0.2');


% --- Executes on selection change in popupmenu2.
function popupmenu2_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns popupmenu2 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu2


% --- Executes during object creation, after setting all properties.
function popupmenu2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
set(hObject, 'String', 'NA');

% --- Executes on button press in pushbutton5.
function pushbutton5_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
results = evalin('base','results');
x = get(handles.popupmenu2, 'Value');
speaks  = evalin('base','speaks');
if ~isempty(speaks),
    imshow(sprintf('%s/figures/peak_%d.jpg',results.name,results.peaksR{speaks(x)}.id),'Parent',handles.axes4);
    imshow(sprintf('%s/figures/peak_window_%d.jpg',results.name,results.peaksR{speaks(x)}.window),'Parent',handles.axes5);
end



function peaklist_Callback(hObject, eventdata, handles)
% hObject    handle to peaklist (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of peaklist as text
%        str2double(get(hObject,'String')) returns contents of peaklist as a double


% --- Executes during object creation, after setting all properties.
function peaklist_CreateFcn(hObject, eventdata, handles)
% hObject    handle to peaklist (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function corrlist_Callback(hObject, eventdata, handles)
% hObject    handle to corrlist (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of corrlist as text
%        str2double(get(hObject,'String')) returns contents of corrlist as a double


% --- Executes during object creation, after setting all properties.
function corrlist_CreateFcn(hObject, eventdata, handles)
% hObject    handle to corrlist (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
