function s = clusterize(s,d_cluster,t_cluster,t_peak)
%clusterize - Computes peak clusters on a reference metabolite spectrum
%
% Syntax:  s = clusterize(s,d_cluster,t_cluster,t_peak)
%
% See also compound_identification
%
% Author:  Arnald Alonso - Rheumatology Research Group (VHIR)
% email:   arnald.alonso@vhir.org
% Website: http://www.urr.cat
% June 2013; Last revision: 01-June-2013

%------------- BEGIN CODE --------------
[~,i]   = sort(s.spect(:,1),'descend');
s.spect = [s.spect(i,:) ones(length(i),1)];
ic = 1;
if length(i) > 1,
    for j = 2:length(i),
        if s.spect(j-1,1)-s.spect(j,1) > d_cluster,
            ic = ic+1;
        end
        s.spect(j,3) = ic;            
    end
end
s.nclusters = ic; 
if size(s.spect,1) > 1,
    while(1),
        d = abs(diff(s.spect(:,1)));
        [md,id] = min(d);
        if md > 2*t_peak,
            break;
        else
            [~,id2] = min(s.spect([id id+1],2));
            s.spect = s.spect(setdiff(1:size(s.spect,1),id+id2(1)-1),:);
        end
    end
end
lim = zeros(ic,2);
for i = 1:ic,
    lim(i,1) = min(s.spect((s.spect(:,3)==i),1))-t_cluster;
    lim(i,2) = max(s.spect((s.spect(:,3)==i),1))+t_cluster;
end
s.lim   = lim;
s.ncomp = zeros(ic,1);
for i = 1:ic,
    s.ncomp(i) = length(find(s.spect(:,3)==i));
end
s.spect(:,2) = s.spect(:,2) / max(s.spect(:,2));