function comp = intercluster(comp,ppms,C,t_corr)
%intercluster - Matches intercluster patterns
%
% Syntax:  comp = intercluster(comp,ppms,C,t_corr)
%
% See also compound_identification
%
% Author:  Arnald Alonso - Rheumatology Research Group (VHIR)
% email:   arnald.alonso@vhir.org
% Website: http://www.urr.cat
% June 2013; Last revision: 01-June-2013

%------------- BEGIN CODE --------------
ncand = zeros(comp.nclusters,1);
cand  = cell(comp.nclusters,1);
for i = 1:comp.nclusters, 
    if comp.cluster{i}.id == 0,
        if ~isempty(comp.cluster{i}.notlinked),
            cand{i} = [zeros(1,length(comp.cluster{i}.notlinked)); comp.cluster{i}.notlinked'];
            cand{i} = [cand{i}; zeros(1,size(cand{i},2))];
            cand{i} = [cand{i}; i*ones(1,size(cand{i},2))];
            z = [];
            for jj=1:length((comp.cluster{i}.notlinked)),
                kk      = find(comp.spect(:,3)==i);
                [~,kkk] = min(abs(ppms(comp.cluster{i}.notlinked(jj))-comp.spect(kk,1)));
                z       = [z kk(kkk(1))];
            end
            cand{i}  = [cand{i}; z; zeros(3,size(cand{i},2))];
            ncand(i) = length(comp.cluster{i}.notlinked);
        end
    else
        j = find(comp.cluster{i}.indM>0);
        cand{i}  = [ones(1,length(j));comp.cluster{i}.indM(j)];
        cand{i}  = [cand{i} [zeros(1,length(comp.cluster{i}.notlinked));comp.cluster{i}.notlinked]];
        cand{i}  = [cand{i}; zeros(1,size(cand{i},2))];
        cand{i}  = [cand{i}; i*ones(1,size(cand{i},2))];
        ncand(i) = size(cand{i},2);
        z = comp.cluster{i}.ind(j);
        if ~isempty(comp.cluster{i}.notlinked),
            for jj = 1:length((comp.cluster{i}.notlinked)),
                kk      = find(comp.spect(:,3)==i);
                [~,kkk] = min(abs(ppms(comp.cluster{i}.notlinked(jj))-comp.spect(kk,1)));
                z       = [z kk(kkk(1))];
            end
        end
        cand{i} = [cand{i}; z];
        cand{i} = [cand{i}; [comp.cluster{i}.C(j) zeros(1,length(comp.cluster{i}.notlinked))]];
        cand{i} = [cand{i}; [repmat(comp.cluster{i}.dis(1),1,length(j)) zeros(1,length(comp.cluster{i}.notlinked))]];
        cand{i} = [cand{i}; [repmat(comp.cluster{i}.dis(2),1,length(j)) zeros(1,length(comp.cluster{i}.notlinked))]];
    end
end
j = find(ncand>0);
indexs = [];
if (length(j)>1) && (comp.nclusters>1),
    indexs = npermutek(1:max(ncand),length(j));
    for k = 1:length(j),
        indexs = indexs(indexs(:,k) < ncand(j(k))+1,:);
    end
    for k = 1:length(j),
        indexs(:,k) = cand{j(k)}(2,indexs(:,k));
    end
    s = size(indexs,2);
    if size(indexs,1)>100,
        c = size(indexs,1);
        for i=1:size(indexs,1), c(i) = sum(sum(C(indexs(i,:),indexs(i,:)))); end
        [~, ic] = sort(c,'descend');
        indexs = indexs(ic,:);
    end
    c = zeros(size(indexs,1),size(indexs,2));
    c2= zeros(size(indexs,1),size(indexs,2));
    in= cell(size(indexs,1),size(indexs,2));
    for i = 1:size(indexs,1),
        for jj = 1:size(indexs,2),
            y  = setdiff(1:length(j),jj);
            kk = find(C(indexs(i,jj),indexs(i,y))>t_corr);
            c(i,jj) = length(kk);
            c2(i,jj)= mean(C(indexs(i,jj),indexs(i,y(kk))));
            in{i,jj}= sort([y(kk) jj]);
        end
    end
    [cc,jj] = max(max(c));
    if cc > 0,
        ix    = find(c(:,jj)==cc);
        [~,y] = max(c2(ix,jj));
        cand  = [j(in{ix(y),jj})';indexs(ix(y),in{ix(y),jj})];
    else
        cand = [];
    end
else
    cand = [];
end
comp.intercluster = cand;