function comp  = intracluster(comp,ppms,C,t_peak,t_corr)
%intracluster - Matches intracluster patterns
%
% Syntax:  comp  = intracluster(comp,ppms,C,t_peak,t_corr)
%
% See also compound_identification
%
% Author:  Arnald Alonso - Rheumatology Research Group (VHIR)
% email:   arnald.alonso@vhir.org
% Website: http://www.urr.cat
% June 2013; Last revision: 01-June-2013

%------------- BEGIN CODE --------------
cluster = cell(1,comp.nclusters);
for ic = 1:comp.nclusters,
    cluster{ic}.id = 0;
    if comp.ncomp(ic) < 2,
        i = find((comp.lim(ic,1) <= ppms) & (comp.lim(ic,2) >= ppms));
        cluster{ic}.notlinked = i;
    else
        index = find(comp.spect(:,3)==ic);
        d     = comp.lim(ic,1):(t_peak/2):comp.lim(ic,2);
        d     = d-min(comp.spect(index,1));
        %d     = d(d+max(comp.spect(index,1)) < comp.lim(ic,2));
        d0 = comp.lim(ic,1)-min(comp.spect(index,1));
        d1 = comp.lim(ic,2)-max(comp.spect(index,1));
        d  = d0:(t_peak/2):d1;
        if isempty(d), d = 0; end
        r_cor = [];
        r_ind = [];    
        r_dis = [];
        for id = 1:length(d),
            candi  = [];
            for i = 1:comp.ncomp(ic),
                j = find(abs(ppms-(comp.spect(index(i),1)+d(id))) < t_peak);
                if ~isempty(j), candi = [candi; j]; end
            end
            candi = unique(candi);
            ncand = zeros(comp.ncomp(ic),1);
            cand  = cell(comp.ncomp(ic),1);
            for i = 1:length(candi), 
                [~,j]    = min(abs(ppms(candi(i))-(comp.spect(index,1)+d(id))));
                ncand(j) = ncand(j)+1;
                cand{j}  = [cand{j} candi(i)];
            end
            j = find(ncand>0);
            indexs = [];
            r = zeros(length(ncand),1);
            if length(j) > 1,
                indexs = npermutek(1:max(ncand),length(j));
                for k = 1:length(j),
                    indexs = indexs(indexs(:,k) < ncand(j(k))+1,:);
                end
                for k = 1:length(j),
                    indexs(:,k) = cand{j(k)}(indexs(:,k));
                end
                c = zeros(1,size(indexs,1));
                for i = 1:size(indexs,1),
                    c(i) = mean(mean(C(indexs(i,:),indexs(i,:))));
                end
                [~,k]  = max(c);
                r(j)   = indexs(k,:)';
                %% CORRELATION
                c      = zeros(comp.ncomp(ic),comp.ncomp(ic));
                c(j,j) = C(r(j),r(j));
                cp     = zeros(1,comp.ncomp(ic));
                exc    = [];
                inc    = 1:comp.ncomp(ic);
                while (1),
                    for kk = 1:comp.ncomp(ic),
                        if all(exc ~= kk),
                            cp(kk) = sum(c(kk,setdiff(inc,[kk exc])))/length(setdiff(inc,[kk exc]));
                        else
                            cp(kk) = 1;
                        end
                    end
                    if all(cp > t_corr), break; end
                    [~,kk] = min(cp);
                    exc    = [exc kk];
                    if length(inc)-length(exc) < 2, 
                        exc = inc;
                        break; 
                    end
                end
                if length(exc) == length(inc), continue; end
                inc  = setdiff(inc,exc);
                r    = zeros(comp.ncomp(ic),1);
                for kk = 1:length(inc),
                    r(inc(kk)) = sum(c(inc(kk),setdiff(inc,inc(kk))))/(length(inc)-1);
                end
                r_cor  = [r_cor; r'];
                %% INDEXES
                ind    = zeros(1,comp.ncomp(ic));
                ind(j) = indexs(k,:);
                r_ind  = [r_ind; ind];
                %% INTRAPEAK DISTANCE MATCHING
                i = find(ind>0);
                if length(i)>1,
                    d1 = diff(comp.spect(index(i),1));
                    d2 = diff(ppms(ind(i)));
                    dd = sqrt(sum((d1-d2).^2));
                end
                r_dis  = [r_dis; [d(id) dd]];
            end
        end
        p   = prod(r_ind,2);
        u   = unique(p);
        ind = zeros(length(u),1);
        for iu = 1:length(u),
            ju      = find(p==u(iu));
            [~,ku]  = min(abs(r_dis(ju,1)));
            ind(iu) = ju(ku(1));
        end
        r_dis = r_dis(ind,:);
        r_cor = r_cor(ind,:);
        r_ind = r_ind(ind,:);
        r_ind(r_cor<t_corr) = 0;
        if isempty(r_ind),
            cluster{ic}.id        = 0; 
            i = find((comp.lim(ic,1) <= ppms) & (comp.lim(ic,2) >= ppms));
            cluster{ic}.notlinked = i;
        else
            Mc    = mean(r_cor,2);
            cmax  = max(Mc);
            i     = find(Mc >= cmax*0.9);
            [~,k] = min(abs(r_dis(i,1)));
            i     = i(k);
            cluster{ic}.id   = 1;
            cluster{ic}.ind  = index';
            cluster{ic}.ppm  = comp.spect(index,1)';
            cluster{ic}.indM = r_ind(i,:);
            cluster{ic}.C    = r_cor(i,:);
            cluster{ic}.dis  = r_dis(i,:);
            [~,ii] = max(r_cor(i,:));
            cluster{ic}.cand = r_ind(i,ii);
            i = find((comp.lim(ic,1) <= ppms) & (comp.lim(ic,2) >= ppms));
            if isempty(cluster{ic}.indM), 
                cluster{ic}.id = 0; 
                cluster{ic}.notlinked = i;
            else
                cluster{ic}.notlinked = setdiff(i,cluster{ic}.indM);
            end
        end
    end
end
comp.cluster = cluster;