function data = peak_identification(results, S, d_cluster, t_cluster, t_peak, t_corr, fig)



D    = dir(results.name);
isub = [D(:).isdir]; %# returns logical vector
D    = {D(isub).name}';
if any(strcmp(D,'peak_identification')) == 0,
    mkdir([results.name '/peak_identification']);
end

index = zeros(1,length(results.peaksR));
ppms  = zeros(1,length(results.peaksR));
I = zeros(length(results.peaksR),length(results.peaksR{1}.areas));
I2= zeros(length(results.peaksR),length(results.peaksR{1}.areas));
for i=1:length(results.peaksR),
    I(i,:) = (results.peaksR{i}.incs);
    I2(i,:) = results.peaksR{i}.areas;
    index(i) = results.peaksR{i}.index;
    ppms(i)  = results.peaksR{i}.ppm;
end
C = corrcoef(I');
% C2= corrcoef(I2');
% for i=1:size(C,1),
%     for j=1:size(C,2),
%         C(i,j) = max(C(i,j),C2(i,j));
%     end
% end
mI= median(I');
dbppm = [];
type  = zeros(1,length(S));
for i=1:length(S),
    a = clusterize(S{i},d_cluster,t_cluster,t_peak);
    dbppm = [dbppm; [i*ones(size(a.spect,1),1) a.spect(:,[3 1 2])]];
    if a.nclusters==1,
        if size(a.spect,1)==1,
            type(i) = 1;
        else
            type(i) = 2;
        end
    else
        type(i) = 3;
    end
end
    
peak_id = {};
data   = [];
fscore = [];
for id=1:length(results.peaksR),
    fprintf('%d/%d...\n',id,length(results.peaksR));
    i = id;
    c = C(i,:);
    j = find(abs(ppms(i)-dbppm(:,3))<t_cluster);
    peak_id{i}.intra = cell(1,length(j));
    peak_id{i}.extra = cell(1,length(j));
    peak_id{i}.results = zeros(length(j),10);
    if ~isempty(j),
        sco = {};
        for cand=1:length(j),
            np = find(dbppm((dbppm(j(cand),1)==dbppm(:,1))&(dbppm(j(cand),2)==dbppm(:,2)),3)==dbppm(j(cand),3));
            ni = setdiff(find((dbppm(:,1)==dbppm(j(cand),1))&(dbppm(:,2)==dbppm(j(cand),2))),j(cand));
            %% INTRACLUSTER
            if ~isempty(ni),
                dist = dbppm(ni,3)-dbppm(j(cand),3);
                ppc  = [ppms(i) + dist - t_peak ppms(i) + dist + t_peak];
                intra_cands = zeros(1,size(ppc,1));
                for intra=1:size(ppc,1),
                    z = find((ppms>=ppc(intra,1))&(ppms<=ppc(intra,2))&(c>t_corr(1))&(ppms~=ppms(i)));
                    if ~isempty(z),
                        [~,zz] = min(abs(ppms(z)-(ppms(i)+dist(intra))));
                        intra_cands(intra) = z(zz);
                    end
                end
                fp = find((ppms>=min(ppc(:)))&(ppms<=max(ppc(:)))&(c>t_corr(1)));
                intra_cands_fp = setdiff(fp,[i intra_cands]);
                %if ~isempty(find(intra_cands>0, 1)),
                dsI = zeros(length(intra_cands)+1,1);
                dsI(intra_cands>0) = mI(intra_cands(intra_cands>0));
                dsI(end) = mI(i);
                liI = [dbppm(ni,4); dbppm(j(cand),4)];
                t = corrcoef([mI(intra_cands(intra_cands>0))';mI(i)],[dbppm(ni(intra_cands>0),4); dbppm(j(cand),4)]);
                t = corrcoef([0;(dsI/max(dsI))],[0;liI/max(liI)]);
                t = t(1,2);
                if sum(dsI)==0, t = 0; end
                %end
            else
                intra_cands = [];
                intra_cands_fp = setdiff(find((abs(ppms-ppms(i))<t_peak)&(c>t_corr(1))),i);
                t = 0;
            end
            
            cc = [id dbppm(j(cand),2) 1];
            if ~isempty(find(intra_cands>0, 1)),
                cc = [cc; [intra_cands(intra_cands>0)' repmat(dbppm(j(cand),2),length(find(intra_cands>0)),1) 0.5*ones(length(find(intra_cands>0)),1)]];
            end
            if ~isempty(intra_cands_fp),
                cc = [cc; [intra_cands_fp' repmat(dbppm(j(cand),2),length(intra_cands_fp),1) zeros(length(intra_cands_fp),1)]];
            end
            
            nok = length(find(intra_cands>0))+1;
            nko = length(intra_cands_fp);
            ntot= length(ni)+1;
            d   = zeros(1,length(intra_cands)+1);
            d(np) = i;
            if np>1,
                d(1:(np-1))=intra_cands(1:(np-1));
            end
            if np<length(intra_cands)+1,
                d((np+1):(length(intra_cands)+1))=intra_cands(np:end);
            end
            dd = zeros(size(d));
            dd(d>0)=index(d(d>0));
            peak_id{i}.results(cand,1:7) = [dbppm(j(cand),1) dbppm(j(cand),2) np nok nko ntot t];
            peak_id{i}.intra{cand} = dd;
            %% INTERCLUSTER
            ne = (dbppm(:,1)==dbppm(j(cand),1))&(dbppm(:,2)~=dbppm(j(cand),2));
            re = (dbppm(:,1)==dbppm(j(cand),1))&(dbppm(:,2)==dbppm(j(cand),2));
            ne = unique(dbppm(ne,2));
            related = [dd(dd>0)];
            scot = [];
            if ~isempty(ne),
                inc = [];
                incT= zeros(length(ne),3);
                scot = zeros(length(ne)+1,2);
                scot(dbppm(j(cand),2),:) = [max(dbppm(re,4)) 1];
                for ec=1:length(ne),
                    points = find((dbppm(:,1)==dbppm(j(cand),1))&(dbppm(:,2)==ne(ec)));
                    scot(ne(ec),1) = max(dbppm(points,4));
                    dist = dbppm(points,3)-dbppm(j(cand),3);
                    ppc  = [min(ppms(i) + dist - t_cluster) max(ppms(i) + dist + t_cluster)];
                    k = find((ppms>=ppc(1))&(ppms<=ppc(2)));
                    kk= k(c(k)>t_corr(1));
                    related = [related index(kk)];
                    inc = [inc; [ne(ec)*ones(length(kk),1) index(kk)']];
                    incT(ec,:) = [ne(ec) length(kk) length(points)];
                    if ~isempty(kk),
                        scot(ne(ec),2) = 1;
                        cc = [cc;[kk' repmat(ne(ec),length(kk),1) 0.5*ones(length(kk),1)]];
                    end
                end
                peak_id{i}.results(cand,8:9) = [length(find(incT(:,2)/incT(:,3) > 0)) length(ne)];
                peak_id{i}.extra{cand} = inc;
            else
                peak_id{i}.results(cand,8:9) = [0 0];
                peak_id{i}.extra{cand} = [];
            end
            sco{cand} = scot;
            peak_id{i}.results(cand,10) = length(setdiff(index(c>t_corr(2)),related));
            ck = setdiff(find(c>t_corr(1)),cc(:,1));
            if ~isempty(ck),
                cc = [cc;[ck' zeros(length(ck),1) 0*ones(length(ck),1)]];
            end
            peak_id{i}.results(cand,8:9) = peak_id{i}.results(cand,8:9) + 1;
            cc = [cc ppms(cc(:,1))' index(cc(:,1))' mI(cc(:,1))' c(cc(:,1))'];
            if fig > 0,
                if (peak_id{i}.results(cand,8)>1) || (peak_id{i}.results(cand,4)>1),
                    plot_candidate(dbppm(j(cand),:),dbppm(dbppm(:,1)==dbppm(j(cand),1),:),cc,S{dbppm(j(cand),1)}.name);
                    export_fig(sprintf('%s/peak_identification/%d_%d',results.name,results.peaksR{i}.index,cand),'-jpg');
                end
            end
        end
        score = zeros(size(peak_id{i}.results,1),5);
        for k=1:size(peak_id{i}.results,1),
            if type(peak_id{i}.results(k,1))==1,
                x = 1-(min(2*t_cluster,abs(results.peaksR{id}.ppm - S{peak_id{i}.results(k,1)}.spect(1,1)))/(2*t_cluster));
                y = max(1-peak_id{i}.results(k,10)*0.1,0);
                z = min(1,mean(results.peaksR{id}.corr));
                score(k,:) = [1 x y z mean([x y z])];
            elseif type(peak_id{i}.results(k,1))==2,
                LE = find((dbppm(:,1)==peak_id{i}.results(k,1))&(dbppm(:,2)==peak_id{i}.results(k,2)));
                if length(LE)>1,
                    x = peak_id{i}.results(k,7);
                else
                    x = 1-(min(2*t_cluster,abs(results.peaksR{id}.ppm - dbppm(LE,3)))/(2*t_cluster));
                end
                y = max(1-peak_id{i}.results(k,10)*0.1,0);
                score(k,:) = [2 x y z mean([x y z])];
            else
                LE = find((dbppm(:,1)==peak_id{i}.results(k,1))&(dbppm(:,2)==peak_id{i}.results(k,2)));
                if length(LE)>1,
                    x = peak_id{i}.results(k,7);
                else
                    x = 1-(min(2*t_cluster,abs(results.peaksR{id}.ppm - dbppm(LE,3)))/(2*t_cluster));
                end
                z = max(1-peak_id{i}.results(k,10)*0.05,0);
                y = sum(sco{k}(:,1).*sco{k}(:,2))/sum(sco{k}(:,1));
                score(k,:) = [3 x y z mean([x y z])];
            end
        end
        peak_id{i}.results = [peak_id{i}.results score];
        data = [data; [id*ones(size(peak_id{i}.results,1),1) peak_id{i}.results]];
        fileID = fopen(sprintf('%s/peak_identification/%d.txt',results.name,results.peaksR{i}.index),'w');
        fprintf(fileID,'METABOLITE\tTYPE\tIC:MATCHING\tIC:TOTAL\tEC:MATCHING\tEC:TOTAL\tOTHERS\tX\tY\tZ\tSCORE\n');
        for cand=1:length(j),
            if type(peak_id{i}.results(cand,1))==1,
                fprintf(fileID,'%s (c:%d/p:%d)\tS\t%d\t%d\t%d\t%d\t%d\t%1.2f\t%1.2f\t%1.2f\t%1.2f\n',S{dbppm(j(cand),1)}.name,dbppm(j(cand),2),peak_id{i}.results(cand,3),peak_id{i}.results(cand,4),peak_id{i}.results(cand,6),peak_id{i}.results(cand,8),peak_id{i}.results(cand,9),peak_id{i}.results(cand,10),score(cand,2),score(cand,3),score(cand,4),score(cand,5));
            else
                fprintf(fileID,'%s (c:%d/p:%d)\tM\t%d\t%d\t%d\t%d\t%d\t%1.2f\t%1.2f\t%1.2f\t%1.2f\n',S{dbppm(j(cand),1)}.name,dbppm(j(cand),2),peak_id{i}.results(cand,3),peak_id{i}.results(cand,4),peak_id{i}.results(cand,6),peak_id{i}.results(cand,8),peak_id{i}.results(cand,9),peak_id{i}.results(cand,10),score(cand,2),score(cand,3),score(cand,4),score(cand,5));
            end
        end
        fclose(fileID);
        
    end
end
fileID = fopen(sprintf('%s/global_id.txt',results.name),'w');
fprintf(fileID,'PEAK\tQC_PEAK\tMETABOLITE\tC::P\tTYPE\tX\tY\tZ\tSCORE\n');
for i=1:size(data,1),
    fprintf(fileID,'%d\t%1.2f\t%s\t%d::%d\t%1.2f\t%1.2f\t%1.2f\t%1.2f\t%1.2f\n',results.peaksR{data(i,1)}.index,mean(results.peaksR{data(i,1)}.corr),S{data(i,2)}.name,data(i,3),data(i,4),data(i,12),data(i,13),data(i,14),data(i,15),data(i,16));
end
fclose(fileID);
fileID = fopen(sprintf('%s/annotated_intensity_data.txt',results.name),'w');
s = '';
for i=1:length(results.samples{1}),
    s = sprintf('%s\t%s',s,results.samples{1}{i});
end
fprintf(fileID,'PEAK\tPPM\tMETABOLITE\tSCORE%s\n',s);
for i=1:length(results.peaksR),
    j = find(i==data(:,1));
    if length(j)>1,
        [a,b] = max(data(j,end));
        s = S{data(j(b),2)}.name;
    else
        a = -1; s = 'ND';
    end
    int = '';
    for j=1:length(results.peaksR{i}.incs), int = sprintf('%s\t%1.5e',int,results.peaksR{i}.incs(j)); end
    fprintf(fileID,'%d\t%1.4f\t%s\t%1.2f%s\n',results.peaksR{i}.index,results.peaksR{i}.ppm,s,a,int);
end
fclose(fileID);