function  plot_candidate(matched,compound,relations,name)

n = [ones(size(compound,1),1) compound(:,2:4) zeros(size(compound,1),3)];
n = [n; [zeros(size(relations,1),1) relations(:,[2 4 6 7 5 3])]];
n((n(:,1)==1)&(n(:,3)==matched(3)),end)=1;
n((n(:,1)==0)&(n(:,3)==relations(1,4)),end)=1;
n(n(:,1)==0,4) = n(n(:,1)==0,4)/max(n(n(:,1)==0,4));
nclusters = length(unique(compound(:,2)));
hFig   = figure(1); clf(1);
set(hFig, 'Position', [0 0 1800 400]);
stem(-1,1,'k','filled','LineWidth',2); hold on;
stem(-1,1,'r','filled','LineWidth',2); hold on;
stem(-1,1,'b','filled','LineWidth',2); hold on;
plot([-1 -1],[0 1],'k--','LineWidth',1);
plot([-1 -1],[0 1],'r--','LineWidth',1);
legend('reference peaks','matched dataset peaks','not matched dataset peaks','reference poi','dataset poi','Location','NorthEastOutside');
plot(zeros(1,2),[0 1],'k-','LineWidth',3); hold on;
nclusters = max(n(:,2));
for j = 1:nclusters,
    plot(j*ones(1,2),[0 1],'k-','LineWidth',3);
    k1  = find((n(:,1)==1)&(n(:,2)==j));
    k2  = find((n(:,1)==0)&(n(:,2)==j));
    L1  = min(n([k1' k2'],3));
    L2  = max(n([k1' k2'],3));
    if L1 == L2,
        L1 = L1-L1*0.01;
        L2 = L2+L2*0.01;
    end
    leg{j} = sprintf('%d / %d / %1.3f-%1.3f',j,length(k1),L1,L2);
    d   = (L2-L1)*0.1;
    L1  = L1-d;
    L2  = L2+d;
    for k = 1:length(k1), 
        x = ((n(k1(k),3)-L1)/(L2-L1))+j-1;
        stem(x,n(k1(k),4),'k','filled','LineWidth',2);
        if n(k1(k),7)==1,
            plot([x x],[0 1],'k--');
        end
    end
    if ~isempty(k2),
        for k = 1:length(k2),
            x = ((n(k2(k),3)-L1)/(L2-L1))+j-1;
            if n(k2(k),7)>0,
                stem(x,n(k2(k),4),'r','filled','LineWidth',2);
                text(x,1.00,sprintf('%d',n(k2(k),6)),'color','k','HorizontalAlignment','center','VerticalAlignment','bottom','Margin',1,'FontSize',7);
            else
                stem(x,n(k2(k),4),'b','filled','LineWidth',2);
                text(x,1.00,sprintf('%d',n(k2(k),6)),'color','k','HorizontalAlignment','center','VerticalAlignment','bottom','Margin',1,'FontSize',7);
            end
            if n(k2(k),7)==1,
                plot([x x],[0 1],'r--');
            end
        end
    end
end
set(gca,'XTick',(1:nclusters)-0.5); xlim([-0.01 nclusters+0.01]);
set(gca,'XTickLabel',leg);xlabel('cluster / N_{peaks} / ppm');
title(sprintf('%s (Nclusters=%d)',name,nclusters));

