function stats = resume_compound(comp,ppms,I,C,indexes,ct,fig,path)
%resume_compound - Summarizes compound identification
%
% Syntax:  stats = resume_compound(comp,ppms,I,C,indexes,ct,fig,path)
%
% See also compound_identification
%
% Author:  Arnald Alonso - Rheumatology Research Group (VHIR)
% email:   arnald.alonso@vhir.org
% Website: http://www.urr.cat
% June 2013; Last revision: 01-June-2013

%------------- BEGIN CODE --------------
C(C<0) = 0;
hFig   = figure(fig); clf(fig);
set(hFig, 'Position', [0 0 1800 400]);
stem(-1,1,'b','filled','LineWidth',2); hold on;
plot([-1 -1],[0 1],'k--','LineWidth',1);
plot([-1 -1],[0 1],'r--','LineWidth',1);
plot(-1,0,'k^');
plot(-1,0,'r.','MarkerSize',20);
plot(-1,0,'m.','MarkerSize',20);
legend('reference spectral peaks','dataset peaks (no intracluster matching)','dataset peaks (intracluster matching)',...
    'intracluster normalized intensities','intracluster correlation','intercluster correlation','Location','NorthEastOutside');
plot(zeros(1,2),[0 1],'k-','LineWidth',3); 
index = zeros(1,comp.nclusters);
leg   = cell(1,comp.nclusters);
stats = [];
for j = 1:comp.nclusters,
    plot(j*ones(1,2),[0 1],'k-','LineWidth',3);
    k1  = find(comp.spect(:,3)==j);
    k21 = [];
    k22 = [];
    if comp.cluster{j}.id >= 0,
        if comp.cluster{j}.id > 0, k21 = comp.cluster{j}.indM(comp.cluster{j}.indM>0); end
        k22 = comp.cluster{j}.notlinked;
    end
    if ~isempty(k1) && ~isempty([k21 k22]),
        L1  = min(min(ppms([k21 k22])),min(comp.spect(k1,1)));
        L2  = max(max(ppms([k21 k22])),max(comp.spect(k1,1)));
    elseif ~isempty(k1),
        L1  = min(comp.spect(k1,1));
        L2  = max(comp.spect(k1,1));
    else
        L1  = min(ppms(r(1,[k21 k22])));
        L2  = max(ppms(r(1,[k21 k22])));
    end
    leg{j} = sprintf('%d / %d / %1.3f-%1.3f',j,length(find(comp.spect(:,3)==j)),L1,L2);
    if L1 == L2,
        L1 = L1-L1*0.1;
        L2 = L2+L2*0.1;
    end
    d   = (L2-L1)*0.1;
    L1  = L1-d;
    L2  = L2+d;
    for k = 1:length(k1),
        x = ((comp.spect(k1(k),1)-L1)/(L2-L1))+j-1;
        stem(x,[comp.spect(k1(k),2)],'b','filled','LineWidth',2);
    end
    stats1 = [];
    stats2 = [];
    if ~isempty(k21),
        stats1 = zeros(length(k21),6);
        stats1(:,1) = j;
        stats1(:,2) = k21';
        stats1(:,3) = 1;
        for k = 1:length(k21),
            x = ((ppms(k21(k))-L1)/(L2-L1))+j-1;
            plot(x*ones(1,2),[0 1],'r--','LineWidth',1);
            text(x,0.00,sprintf('%1.2f',ct(k21(k))),'color','r','HorizontalAlignment','center','VerticalAlignment','bottom','Margin',1,'FontSize',7);
            text(x,1.00,sprintf('%d',indexes(k21(k))),'color','r','HorizontalAlignment','center','VerticalAlignment','bottom','Margin',1,'FontSize',7);
            temp1 = comp.cluster{j}.C(comp.cluster{j}.indM==k21(k));
            plot(x,temp1,'r.','MarkerSize',20);
            if ~isempty(comp.intercluster),
                tt = find(comp.intercluster(1,:)==j);
                if ~isempty(tt),
                    if k21(k)==comp.intercluster(2,tt),
                        temp = 1; temp2 = mean(C(k21(k),setdiff(comp.intercluster(2,:),k21(k))));
                        plot(x,temp2,'m.','MarkerSize',20);
                    else
                        temp = 0; temp2 = mean(C(k21(k),setdiff(comp.intercluster(2,:),comp.intercluster(2,tt))));
                        plot(x,temp2,'mo','MarkerSize',7);
                    end
                else
                    temp = 0; temp2 = mean(C(k21(k),comp.intercluster(2,:)));
                    plot(x,temp2,'mo','MarkerSize',7);
                end
            else
                temp = -1; temp2 = -1;
            end
            stats1(k,4:6) = [temp1 temp temp2];
            plot(x,I(k21(k))/max(I([k21 k22])),'k^'); 
        end
    end
    if ~isempty(k22),
        stats2 = zeros(length(k22),6);
        stats2(:,1) = j;
        stats2(:,2) = k22';
        stats2(:,3) = 0;
        for k=1:length(k22),
            x = ((ppms(k22(k))-L1)/(L2-L1))+j-1;
            plot(x*ones(1,2),[0 1],'k--','LineWidth',1);
            text(x,0.00,sprintf('%1.2f',ct(k22(k))),'color','k','HorizontalAlignment','center','VerticalAlignment','bottom','Margin',1,'FontSize',7);
            text(x,1.00,sprintf('%d',indexes(k22(k))),'color','k','HorizontalAlignment','center','VerticalAlignment','bottom','Margin',1,'FontSize',7);
            if ~isempty(k21),
                temp1 = max(C(k22(k),k21));
                plot(x,temp1,'ro','MarkerSize',7);
            else
                temp1 = -1;
            end
            if ~isempty(comp.intercluster),
                tt = find(comp.intercluster(1,:)==j);
                if ~isempty(tt),
                    if k22(k)==comp.intercluster(2,tt),
                        temp = 1; temp2 = mean(C(k22(k),setdiff(comp.intercluster(2,:),k22(k))));
                        plot(x,temp2,'m.','MarkerSize',20);
                    else
                        temp = 0; temp2 = mean(C(k22(k),setdiff(comp.intercluster(2,:),comp.intercluster(2,tt))));
                        plot(x,temp2,'mo','MarkerSize',7);
                    end
                else
                    temp = 0; temp2 = mean(C(k22(k),comp.intercluster(2,:)));
                    plot(x,temp2,'mo','MarkerSize',7);
                end
            else
                temp = -1; temp2 = -1;
            end
            plot(x,I(k22(k))/max(I([k21 k22])),'k^'); 
            stats2(k,4:6) = [temp1 temp temp2];
        end
    end
    stats = [stats; stats1; stats2];
end
set(gca,'XTick',(1:comp.nclusters)-0.5); xlim([-0.01 comp.nclusters+0.01]);
set(gca,'XTickLabel',leg);xlabel('cluster / N_{peaks} / ppm');
title(sprintf('%s (Nclusters=%d)',comp.name,comp.nclusters));
export_fig(path,'-tif','-m1');
if ~isempty(stats),
    stats = [stats(:,1:2) ppms(stats(:,2)) I(stats(:,2)) stats(:,3:end)];
    stats(:,2) = indexes(stats(:,2));
end
