import os as os
import shutil as sh
from time import gmtime, strftime
import random as random
scale = [0.00, 0.10, 0.20, 0.30, 0.40, 0.50, 0.60, 0.70, 0.80, 0.90]
scale2= [0.60, 0.64, 0.68, 0.72, 0.76, 0.80, 0.84, 0.88, 0.92, 0.96]
scaleC= ["#FF0000", "#FF3800", "#FF7100" ,"#FFAA00" ,"#FFE200" ,"#FFFF1C" ,"#FFFF54" ,"#FFFF8D" ,"#FFFFC6", "#FFFFFF"]
#scaleG= ['#FF0000FF','#FF0F00FF','#FF1F00FF','#FF2E00FF','#FF3D00FF','#FF4D00FF','#FF5C00FF','#FF6B00FF','#FF7A00FF','#FF8A00FF','#FF9900FF','#FFA800FF','#FFB800FF','#FFC700FF','#FFD600FF','#FFE500FF','#FFF500FF','#FAFF00FF','#EBFF00FF','#DBFF00FF','#CCFF00FF','#BDFF00FF','#ADFF00FF','#9EFF00FF','#8FFF00FF','#80FF00FF','#70FF00FF','#61FF00FF','#52FF00FF','#42FF00FF','#33FF00FF','#24FF00FF','#14FF00FF','#05FF00FF','#00FF0AFF','#00FF1AFF','#00FF29FF','#00FF38FF','#00FF47FF','#00FF57FF','#00FF66FF','#00FF75FF','#00FF85FF','#00FF94FF','#00FFA3FF','#00FFB3FF','#00FFC2FF','#00FFD1FF','#00FFE0FF','#00FFF0FF','#00FFFFFF','#00F0FFFF','#00E0FFFF','#00D1FFFF','#00C2FFFF','#00B2FFFF','#00A3FFFF','#0094FFFF','#0085FFFF','#0075FFFF','#0066FFFF','#0057FFFF','#0047FFFF','#0038FFFF','#0029FFFF','#0019FFFF','#000AFFFF','#0500FFFF','#1400FFFF','#2400FFFF','#3300FFFF','#4200FFFF','#5200FFFF','#6100FFFF','#7000FFFF','#8000FFFF','#8F00FFFF','#9E00FFFF','#AD00FFFF','#BD00FFFF','#CC00FFFF','#DB00FFFF','#EB00FFFF','#FA00FFFF','#FF00F5FF','#FF00E6FF','#FF00D6FF','#FF00C7FF','#FF00B8FF','#FF00A8FF','#FF0099FF','#FF008AFF','#FF007AFF','#FF006BFF','#FF005CFF','#FF004CFF','#FF003DFF','#FF002EFF','#FF001FFF','#FF000FFF']
scaleG= ['#E5E4E2','#98AFC7','#736AFF','#357EC7','#3BB9FF','#7FFFD4','#728C00','#52D017','#FFD801','#FFCBA4','#FF8040','#F778A1','#FF00FF','#C45AEC','#E0B0FF','#FFFFFF']

## C:/Users/aalonso/Desktop/focus/analysis/validate/liver_final
print "#########################################"
print "### FOCUS HTML-REPORT GENERATION TOOL ###"
print "#########################################"
print ""
path    = raw_input('Please, enter valid path to the Matlab analysis folder: ')
dataset = raw_input('Please, enter analysis identifier:')
print ""
print "VERIFYING REQUIRED DATA:"
## VALIDATE DATASET AND REQUIRED FILES
try:
    N = os.listdir(path)
except:
    print "Path does not exist."
    exit()
sweb = 0
spd  = 0
spdd = 0
for i in N:
    if i == "web":
        sh.rmtree(path+'/web')
    if i == "peak_data.txt":
        spd = 1
    if i == "peak_data":
        spdd = 1
    if i=="peak_identification":
        sweb = 1
if spd == 0:
    print "- Peak data file not found ('"+path+"/peak_data.txt')"
    exit()
if spdd == 0:
    print "- Peak data directory not found ('"+path+"/peak_data')"
    exit()

print "- Peak data file found:"
print "  "+path+"/peak_data.txt"
print "- Peak data directory found:"
print "  "+path+"/peak_data"
if sweb == 1:
    print "- Identification directory found:"
    print "  "+path+"/peak_identification"
else:
    print "- Identification directory not found ('"+path+"/peak_identification')"
print ""
## GENERATE DIRECTORY STRUCTURE
print "GENERATING REPORT DIRECTORY STRUCTURE AND READING INPUT DATA:"
print "- HTML-REPORT created @ "+path+"/web"
os.mkdir(path+"/web")
sh.copytree("html",path+"/web/html")
## READ PEAK DATA FILE
f = open(path+"/peak_data.txt",'r')
pd_h = f.readline().strip("\n").split("\t")
pd_b = list()
for i in f:
    pd_b.append(i.strip("\n").split("\t"))
f.close()
print "- Peak data file read: "+str(len(pd_b))+" detected peaks"
print ""
## READ METABOLITE IDENTIFICATION FILES
print "READING METABOLITE IDENTIFICATION FILES:"
if sweb == 1:
    N = os.listdir(path+"/peak_identification")
    NM= dict()
    for fn in N:
        if fn.endswith(".txt"):
            f = open(path+"/peak_identification/"+fn,'r')
            i = f.readline()
            for i in f:
                i = i.strip("\n").split("\t")
                n = i[0].split(" ")[0]
                if NM.has_key(n)==False:
                    NM[n]=[[],[]]
                NM[n][0].append(float(i[10]))
                NM[n][1].append(fn.replace(".txt",""))
            f.close()
    NF = dict()
    for i,j in NM.iteritems():
        m = 0
        for k in j[0]:
            if k>m:
                m=k
        NF[i]=dict()
        for k in range(len(j[0])):
            if j[0][k]>=0.9*m:
                NF[i][j[1][k]]=1
    print "- Identifications found for "+str(len(NF))+" metabolites"
else:
    print "- Identification data unavailable"
print ""
## FORMAT PEAK DATA TABLE
print "FORMATTING PEAK DATA TABLE..."
print ""
random.shuffle(scaleG)
peakids = list()
ppms = list()
windows = list()
for i in range(len(pd_b)):
    # peak_id
    pd_b[i][0]
    pi = os.listdir(path+"/peak_identification")
    values = ["",""]
    if pd_b[i][0]+".txt" in pi:
        f = open(path+"/peak_identification/"+pd_b[i][0]+".txt",'r')
        j = f.readline()
        minm= [-1,""]
        for j in f:
            if float(j.strip("\n").split("\t")[10])>minm[0]:
                minm[0] = float(j.strip("\n").split("\t")[10])
                minm[1] = j.strip("\n").split(" ")[0]
        f.close()
        if (minm[0]<1.1) and (minm[0]>0.6):
            values = [minm[1],str(minm[0])]
        else:
            values = ["",""]
    else:
        values = ["",""]
    peakids.append(pd_b[i][0])
    pd_b[i][0] = '<td><a href="../figures/peak_'+pd_b[i][0] +'.jpg" class="lytebox lytetip" data-tip="" data-title="PEAK NUMER '+pd_b[i][0] +'" data-description="" data-lyte-options="showPrint:true tipStyle:classic">p'+pd_b[i][0]+'</a>'+'</td>'
    # peak_ppm
    ppms.append(str(round(float(pd_b[i][1]),3)))
    pd_b[i][1] = '<td>'+str(round(float(pd_b[i][1]),3))+'</td>'
    # window
    windows.append(pd_b[i][2])
    j = pd_b[i][2]
    pd_b[i][2] = pd_b[i][2]+' ('+str(round(float(pd_b[i][3]),3))+'-'+str(round(float(pd_b[i][4]),3))+')'
    pd_b[i][2] = '<td><a href="../figures/alignment_'+j+'.jpg" class="lytebox lytetip" data-tip="" data-title="ALIGNMENT ON WINDOW '+j+'" data-description="" data-lyte-options="showPrint:true tipStyle:classic">'+pd_b[i][2]+'</a></td>'
    # quality controls
    for j in range(5,8):
        r = round(float(pd_b[i][j]),2)
        color = ""
        for k in range(len(scale)):
            if r >= scale[k]:
                color = scaleC[k]
        pd_b[i][j] = '<td bgcolor="'+color+'" class=" ">'+str(r)+'</td>'
    # groups
    m = ["G95_","G90_","G85_","G80_"]
    for j in range(8,12):
        g = pd_b[i][j]
        gC= scaleG[(int(pd_b[i][j]) % len(scaleG))]
        n = 0
        for k in range(len(pd_b)):
            if (pd_b[k][j]==g) or ('>'+m[j-8]+g+' (' in pd_b[k][j]):
                n+=1
        pd_b[i][j] = '<td bgcolor="'+gC+'">'+m[j-8]+g+' ('+str(n)+')</td>'
    color = ""
    if NF.has_key(values[0]):
        if NF[values[0]].has_key(peakids[i]):
            color = "1"
    if len(color)==0:
        pd_b[i].append('<td>'+values[0]+'</td>')
    else:
        pd_b[i].append('<td bgcolor="#00FF00">'+values[0]+'</td>')
    if len(values[1])>0:
        r = round(float(values[1]),2)
        color = ""
        for k in range(len(scale2)):
            if r >= scale2[k]:
                color = scaleC[k]
    else:
        color=''
        r = ''
    pd_b[i].append('<td bgcolor="'+color+'" class=" ">'+str(r)+'</td>')
## WRITE HTML SUMMARY REPORT
print "WRITING SUMMARY REPORT:"
print "- Summary report @ '"+path+"/web/dataset.html'"
out = open(path+"/web/dataset.html",'w')
f = open("supp/header.txt",'r')
for i in f:
    print >> out, i.strip("\n").replace("##name","FOCUS / "+dataset)
f.close()
print >> out, '<body>'
print >> out, '<div id="header"><img src="./html/css/images/header.png"></div>'
print >> out, '<div id="box1"><div id="content">'
print >> out, "<h1>FOCUS ANALYSIS RESULTS</h1>"
print >> out, "<h2>STUDY NAME: "+dataset+" / "+strftime("%Y-%m-%d %H:%M:%S", gmtime())+'</h2>'
print >> out, "<center>"
print >> out, '<table border="1" class="display dataTable" id="focus_peak_table" style="width:80%">'
header = "<thead><tr>"
for i in [0,1,2,5,6,7,8,9,10,11]:
    header = header + '<td>' +pd_h[i]+ '</td>'
    if i==0:
        header = header +'<td>INFO</td>'
    if i==2:
        header = header +'<td bgcolor="#000000"></td>'
    if i==7:
        header = header +'<td bgcolor="#000000"></td>'
    if i==11:
        header = header + '<td bgcolor="#000000"></td><td>ID</td><td>ID_SCO</td>'
header = header + '</tr></thead>'
print >> out, header
print >> out, '<tbody role="alert" aria-live="polite" aria-relevant="all">'
for i in range(len(pd_b)):
    if i % 2 == 0:
        n = '<tr class="even">'
    else:
        n = '<tr class="odd">'
    for j in [0,1,2,5,6,7,8,9,10,11]:
        n = n+pd_b[i][j]
        if j==0:
            n=n+'<td>'+'<a href="peaks/'+pd_b[i][j].split('>p')[1].split('<')[0]+'.html" target="_blank">+</a>'+'</td>'
        if j==2:
            n=n+'<td bgcolor="#000000"></td>'
        if j==7:
            n=n+'<td bgcolor="#000000"></td>'
        if j==11:
            if sweb == 1:
                n=n+'<td bgcolor="#000000"></td>'+pd_b[i][12]+pd_b[i][13]
            else:
                n=n+'<td bgcolor="#000000"></td><td></td><td></td>'
    n = n+'</tr>'
    print >> out, n
print >> out, "</tbody></table></center></div></div></body></html>"
out.close()
print ""
## WRITE HTML PEAK REPORTS
print "WRITING HTML PEAK REPORTS:"
print "- Peak report @ '"+path+"/web/peaks/[peak_id].html'"
print ""
pd_bb = pd_b
os.mkdir(path+"/web/peaks")
kk = 0
for peak in peakids:
    out = open(path+"/web/peaks/"+peak+".html",'w')
    f = open("supp/header2.txt",'r')
    for i in f:
        print >> out, i.strip("\n").replace("##name",peak)
    f.close()
    print >> out, '<body><div id="box1"><div id="content">'
    print >> out, "<h1>PEAK "+peak+" ("+ppms[kk]+" ppm) DETAILS</h1>"
    print >> out, "<h2>GENERAL INFORMATION</h2>"
    print >> out, "<h3>PEAK DETECTION</h3>"
    print >> out, '<center><img src="../../figures/peak_'+peak+'.jpg" width="1000"></center><br>'
    print >> out, "<h3>WINDOW ALIGNMENT</h3>"
    print >> out, '<center><img src="../../figures/alignment_'+windows[kk]+'.jpg" width="1000"></center><br>'
    print >> out, "<h3>INTENSITY DISTRIBUTION</h3>"
    print >> out, '<center><img src="../../peak_data/intensity_'+peak+'.jpg" width="1000"></center><br>'
    print >> out, "<h2>CORRELATION ANALYSIS</h2>"
    ## READ PEAK DATA FILE
    NN = os.listdir(path+"/peak_data")
    pd_h = [];
    np = 0
    if peak+".txt" in NN:
        np = np + 1
        f = open(path+"/peak_data/"+peak+".txt",'r')
        pd_h = f.readline().strip("\n").split("\t")
        pd_b = list()
        for i in f:
            pd_b.append(i.strip("\n").split("\t"))
        f.close()
        ## FORMAT PEAK DATA TABLE
        scale = [0, 0.1, 0.2 ,0.3, 0.4 ,0.5 ,0.6, 0.7, 0.8, 0.9]
        scaleC= ["#FF0000", "#FF3800", "#FF7100" ,"#FFAA00" ,"#FFE200" ,"#FFFF1C" ,"#FFFF54" ,"#FFFF8D" ,"#FFFFC6", "#FFFFFF"]
        scaleG= ['#FF0000FF','#FF0F00FF','#FF1F00FF','#FF2E00FF','#FF3D00FF','#FF4D00FF','#FF5C00FF','#FF6B00FF','#FF7A00FF','#FF8A00FF','#FF9900FF','#FFA800FF','#FFB800FF','#FFC700FF','#FFD600FF','#FFE500FF','#FFF500FF','#FAFF00FF','#EBFF00FF','#DBFF00FF','#CCFF00FF','#BDFF00FF','#ADFF00FF','#9EFF00FF','#8FFF00FF','#80FF00FF','#70FF00FF','#61FF00FF','#52FF00FF','#42FF00FF','#33FF00FF','#24FF00FF','#14FF00FF','#05FF00FF','#00FF0AFF','#00FF1AFF','#00FF29FF','#00FF38FF','#00FF47FF','#00FF57FF','#00FF66FF','#00FF75FF','#00FF85FF','#00FF94FF','#00FFA3FF','#00FFB3FF','#00FFC2FF','#00FFD1FF','#00FFE0FF','#00FFF0FF','#00FFFFFF','#00F0FFFF','#00E0FFFF','#00D1FFFF','#00C2FFFF','#00B2FFFF','#00A3FFFF','#0094FFFF','#0085FFFF','#0075FFFF','#0066FFFF','#0057FFFF','#0047FFFF','#0038FFFF','#0029FFFF','#0019FFFF','#000AFFFF','#0500FFFF','#1400FFFF','#2400FFFF','#3300FFFF','#4200FFFF','#5200FFFF','#6100FFFF','#7000FFFF','#8000FFFF','#8F00FFFF','#9E00FFFF','#AD00FFFF','#BD00FFFF','#CC00FFFF','#DB00FFFF','#EB00FFFF','#FA00FFFF','#FF00F5FF','#FF00E6FF','#FF00D6FF','#FF00C7FF','#FF00B8FF','#FF00A8FF','#FF0099FF','#FF008AFF','#FF007AFF','#FF006BFF','#FF005CFF','#FF004CFF','#FF003DFF','#FF002EFF','#FF001FFF','#FF000FFF']
        random.shuffle(scaleG)
        for i in range(len(pd_b)):
            # peak_id
            kkk = pd_b[i][1]
            pd_b[i][1] = '<td><a href="../../figures/peak_'+pd_b[i][1] +'.jpg" class="lytebox lytetip" data-tip="" data-title="PEAK NUMER '+pd_b[i][1] +'" data-description="" data-lyte-options="showPrint:true tipStyle:classic">p'+pd_b[i][1]+'</a>'+'</td>'
            # peak_ppm
            pd_b[i][2] = '<td>'+str(round(float(pd_b[i][2]),3))+'</td>'
            # window
            j = pd_b[i][3]
            pd_b[i][3] = pd_b[i][3]+' ('+str(round(float(pd_b[i][4]),3))+'-'+str(round(float(pd_b[i][5]),3))+')'
            pd_b[i][3] = '<td><a href="../../figures/alignment_'+j+'.jpg" class="lytebox lytetip" data-tip="" data-title="ALIGNMENT ON WINDOW '+j+'" data-description="" data-lyte-options="showPrint:true tipStyle:classic">'+pd_b[i][3]+'</a></td>'
            # quality controls
            for j in [0,6,7,8]:
                r = round(float(pd_b[i][j]),2)
                for k in range(len(scale)):
                    if r >= scale[k]:
                        color = scaleC[k]
                pd_b[i][j] = '<td bgcolor="'+color+'" class=" ">'+str(r)+'</td>'
            # groups
            m = ["G95_","G90_","G85_","G80_"]
            for j in range(9,13):
                g = pd_b[i][j]
                gC= scaleG[(int(pd_b[i][j]) % len(scaleG))]
                n = 0
                for k in range(len(pd_bb)):
                    if (pd_bb[k][j-1]==g) or ('>'+m[j-9]+g+' (' in pd_bb[k][j-1]):
                        n+=1
                pd_b[i][j] = '<td bgcolor="'+gC+'">'+m[j-9]+g+' ('+str(n)+')</td>'
            pd_b[i].append('<td><a href="../../peak_data/correlation_'+peak+"_"+kkk+'.jpg" class="lytebox lytetip" data-tip="" data-title="INTENSITY CORRELATION" data-description="" data-lyte-options="showPrint:true tipStyle:classic">+</a></td>')
    print >> out, '<center><img src="../../peak_data/correlation_'+peak+'.jpg" width="1000"></center><br>'
    if len(pd_h)>0:
        print >> out, '<table border="1" class="display dataTable" id="focus_peak_table" style="width:80%">'
        header = "<thead><tr>"
        for i in [0,1,2,3,6,7,8,9,10,11,12]:
            header = header + '<td>' +pd_h[i]+ '</td>'
            if i==1:
                header = header +'<td>INFO</td>'
            if i==3:
                header = header +'<td bgcolor="#000000"></td>'
            if i==8:
                header = header +'<td bgcolor="#000000"></td>'
            if i==12:
                header = header +'<td bgcolor="#000000"></td><td>INFO</td>'
        header = header + '</tr></thead>'
        print >> out, header
        print >> out, '<tbody role="alert" aria-live="polite" aria-relevant="all">'
        for i in range(len(pd_b)):
            if i % 2 == 0:
                n = '<tr class="even">'
            else:
                n = '<tr class="odd">'
            for j in [0,1,2,3,6,7,8,9,10,11,12]:
                n = n+pd_b[i][j]
                if j==1:
                    n=n+'<td>'+'<a href="peaks/'+pd_b[i][j].split('>p')[1].split('<')[0]+'.html" target="_blank">+</a>'+'</td>'
                if j==3:
                    n=n+'<td bgcolor="#000000"></td>'
                if j==8:
                    n=n+'<td bgcolor="#000000"></td>'
                if j==12:
                    n=n+'<td bgcolor="#000000"></td>'+pd_b[i][j+1]
            n = n+'</tr>'
            print >> out, n
        print >> out, "</tbody></table>"
    else:
        print >> out, "No significant correlations found."
    print >> out, "<h2>IDENTIFICATION ANALYSIS</h2>"
    ## READ PEAK IDENTIFICATION FILE
    if sweb == 1:
        NN = os.listdir(path+"/peak_identification")
        pd_h = [];
        if peak+".txt" in NN:
            f = open(path+"/peak_identification/"+peak+".txt",'r')
            pd_h = f.readline().strip("\n").split("\t")
            pd_h.append("FIG")
            pd_b = list()
            for i in f:
                pd_b.append(i.strip("\n").split("\t"))
            f.close()
            ## FORMAT PEAK DATA TABLE
            scale = [0, 0.1, 0.2 ,0.3, 0.4 ,0.5 ,0.6, 0.7, 0.8, 0.9]
            scaleC= ["#FF0000", "#FF3800", "#FF7100" ,"#FFAA00" ,"#FFE200" ,"#FFFF1C" ,"#FFFF54" ,"#FFFF8D" ,"#FFFFC6", "#FFFFFF"]
            scaleG= ['#FF0000FF','#FF0F00FF','#FF1F00FF','#FF2E00FF','#FF3D00FF','#FF4D00FF','#FF5C00FF','#FF6B00FF','#FF7A00FF','#FF8A00FF','#FF9900FF','#FFA800FF','#FFB800FF','#FFC700FF','#FFD600FF','#FFE500FF','#FFF500FF','#FAFF00FF','#EBFF00FF','#DBFF00FF','#CCFF00FF','#BDFF00FF','#ADFF00FF','#9EFF00FF','#8FFF00FF','#80FF00FF','#70FF00FF','#61FF00FF','#52FF00FF','#42FF00FF','#33FF00FF','#24FF00FF','#14FF00FF','#05FF00FF','#00FF0AFF','#00FF1AFF','#00FF29FF','#00FF38FF','#00FF47FF','#00FF57FF','#00FF66FF','#00FF75FF','#00FF85FF','#00FF94FF','#00FFA3FF','#00FFB3FF','#00FFC2FF','#00FFD1FF','#00FFE0FF','#00FFF0FF','#00FFFFFF','#00F0FFFF','#00E0FFFF','#00D1FFFF','#00C2FFFF','#00B2FFFF','#00A3FFFF','#0094FFFF','#0085FFFF','#0075FFFF','#0066FFFF','#0057FFFF','#0047FFFF','#0038FFFF','#0029FFFF','#0019FFFF','#000AFFFF','#0500FFFF','#1400FFFF','#2400FFFF','#3300FFFF','#4200FFFF','#5200FFFF','#6100FFFF','#7000FFFF','#8000FFFF','#8F00FFFF','#9E00FFFF','#AD00FFFF','#BD00FFFF','#CC00FFFF','#DB00FFFF','#EB00FFFF','#FA00FFFF','#FF00F5FF','#FF00E6FF','#FF00D6FF','#FF00C7FF','#FF00B8FF','#FF00A8FF','#FF0099FF','#FF008AFF','#FF007AFF','#FF006BFF','#FF005CFF','#FF004CFF','#FF003DFF','#FF002EFF','#FF001FFF','#FF000FFF']
            random.shuffle(scaleG)
            for i in range(len(pd_b)):
                ## compound
                pd_b[i][0] = '<td>'+pd_b[i][0]+'</td>'
                ## type
                pd_b[i][1] = '<td>'+pd_b[i][1]+'</td>'
                ## IC-MATCHING
                if int(pd_b[i][2])>1:
                    pd_b[i][2] = '<td bgcolor="33FF00" class=" ">'+pd_b[i][2]+'</td>'
                else:
                    pd_b[i][2] = '<td bgcolor="FF0000" class=" ">'+pd_b[i][2]+'</td>'
                ## ic-total
                pd_b[i][3] = '<td>'+pd_b[i][3]+'</td>'
                ## ec-matching
                if int(pd_b[i][4])>1:
                    pd_b[i][4] = '<td bgcolor="33FF00" class=" ">'+pd_b[i][4]+'</td>'
                else:
                    pd_b[i][4] = '<td bgcolor="FF0000" class=" ">'+pd_b[i][4]+'</td>'
                ## ec-total
                pd_b[i][5] = '<td>'+pd_b[i][5]+'</td>'
                ## others
                if int(pd_b[i][6])==0:
                    pd_b[i][6] = '<td bgcolor="33FF00" class=" ">'+pd_b[i][6]+'</td>'
                else:
                    pd_b[i][6] = '<td bgcolor="FF0000" class=" ">'+pd_b[i][6]+'</td>'
                ## scores
                for j in range(7,11):
                    r = round(float(pd_b[i][j]),2)
                    for k in range(len(scale)):
                        if r >= scale[k]:
                            color = scaleC[k]
                    pd_b[i][j] = '<td bgcolor="'+color+'" class=" ">'+str(r)+'</td>'
                ## figure
                if peak+"_"+str(i+1)+".jpg" in NN:
                    pd_b[i].append('<td><a href="../../peak_identification/'+peak+"_"+str(i+1)+'.jpg" class="lytebox lytetip" data-tip="" data-title="INTENSITY CORRELATION" data-description="" data-lyte-options="showPrint:true tipStyle:classic">+</a></td>')
                else:
                    pd_b[i].append('<td></td>')
        if len(pd_h)>0:
            print >> out, '<table border="1" class="display dataTable" id="identification" style="width:80%">'
            header = "<thead><tr>"
            for i in range(len(pd_h)):
                header = header + '<td>' +pd_h[i]+ '</td>'
                if i==1:
                    header = header + '<td bgcolor="#000000"></td>'
                if i==6:
                    header = header + '<td bgcolor="#000000"></td>'
                if i==9:
                    header = header + '<td bgcolor="#000000"></td>'
            header = header + '</tr></thead>'
            print >> out, header
            print >> out, '<tbody role="alert" aria-live="polite" aria-relevant="all">'
            for i in range(len(pd_b)):
                if i % 2 == 0:
                    n = '<tr class="even">'
                else:
                    n = '<tr class="odd">'
                for j in range(len(pd_b[i])):
                    n = n+pd_b[i][j]
                    if j==1:
                        n = n + '<td bgcolor="#000000"></td>'
                    if j==6:
                        n = n + '<td bgcolor="#000000"></td>'
                    if j==9:
                        n = n + '<td bgcolor="#000000"></td>'
                n = n+'</tr>'
                print >> out, n
            print >> out, "</tbody></table>"
        else:
            print >> out, "No significant identifications found."

    else:
        print >> out, "No identification data."
    print >> out, "</div></div></body></html>"
    kk+=1
    out.close()


