#ifndef CNVSCORING_H
#define CNVSCORING_H

#include <cmath>
#include <armadillo>
#include <itpp/stat/mog_diag.h>
#include <itpp/itstat.h>
#include "options.h"
#include "misc.h"

using namespace std;

extern opcions o;

#define SMIN 10
//#define MY_PI (arma::datum::pi)
#define MY_PI 3.14159

struct vmodel
{
  unsigned int ncomp;
  arma::vec::fixed<2> Mean;
  arma::vec::fixed<2> Cov;
  arma::vec::fixed<2> Prior;
  arma::vec::fixed<3> Q;
};

class cnvscoring
{
  public:
  arma::vec FI1;
  arma::vec FI2;
  arma::ivec genotypes;
  arma::vec scg;
  arma::vec INT1;
  arma::vec INT2;
  
  double stdCNP;
  
  //arma::vec farciment; //vector 0->0.1 step 0.001
  
  arma::vec::fixed<3> Q1;
  arma::vec::fixed<3> Q2;
  arma::vec SC;
  
  
  unsigned int nz;
  bool error;
  //arma::vec scor1;
  //arma::vec scor2;
  
  void troba_cnvscoring();
  void channel_analysis(arma::uvec index, arma::uvec index3, arma::vec INT, arma::vec & scor, arma::vec::fixed<3> & Qr);
  vmodel model_selection(arma::vec Iprev, arma::vec sc, double scT, double klT1, double klT2, double klT3);
  arma::vec pdfgauss(arma::vec v, double tmean, double sd2);
  itpp::Array<itpp::vec> arma2itpp(arma::vec v, unsigned int n);
  itpp::vec arma2itppVec(arma::vec v, unsigned int n);
  vmodel emgmm(arma::vec v, vmodel model, unsigned int ndim, unsigned int maxit);
  double kld(vmodel model);
};


#endif