#include "genotype.h"

void genotype::troba_genotypes()
{
  double d, zL, apos;
  //arma::vec GC = arma::vec(3);
  //arma::vec GL = arma::vec(2);
  arma::vec::fixed<3> GC;
  arma::vec::fixed<2> GL;
  unsigned int step;
  unsigned int it, jt, ik;
  unsigned int iapos;
  arma::uvec Ntemp;
  arma::vec N;
  
  //Variable initialization
  error = 0;
  
  genotypes = arma::ivec(FI1.n_elem);
  genotypes.fill(-1);
  ik = 0;
  GC.fill(-1.);
  GL.fill(-1.);
  step = (unsigned int) round((double)(minlen*(double)res));
  
  arma::vec edge  = arma::linspace<arma::vec>(0., 1., res);
  d = edge(1) - edge(0);
  
  //Homozygous deletion detection
  if(zeroD)
  {
    zL = findzeros(FI2);
    for(it = 0; it < FI2.n_elem; it++)
    {
      genotypes(it) = ( FI2(it) < zL ? 0:genotypes(it) );
    }
  }
  else
  {
    zL = 0.;
  }
  
  //BAF distribution normalized to 1
  Ntemp = arma::hist( FI1.elem( arma::find( FI2>zL ) ), edge );
  N = arma::conv_to< arma::vec >::from(Ntemp);
  N = N/N.max();
  arma::vec temp = (edge - 0.5);
  temp = (temp % temp) + 0.75;
  arma::vec Nb = (arma::conv_to< arma::vec >::from(N)) % temp;
  arma::uvec utemp = arma::find(Nb==Nb.max(), 1);
  iapos = utemp(0);
  apos = edge( iapos );
  //apos = temp(0);
  
  //No homozygote peaks?
  if ( fabs(apos-0.5) < 0.25 )
  {
    arma::vec temp1, temp2;
    //utemp1 = arma::find(N==1, 1);
    //i = utemp1(0);
    
    arma::uword b1,b2;
    double a1, a2;
    temp1 = N.elem( arma::find(edge<0.25) );
    a1 = temp1.max(b1);
    temp2 = N.elem( arma::find(edge>0.75) );
    a2 = temp2.max(b2);
    if( (a1>=a2) && (a1>0.05) && (int(b1)<(int(temp1.n_elem) - 1)) )
    {
      apos = edge(b1 + 1);
      iapos = b1 + 1;
    }
    else if( (a1<a2) && (a2>0.05) && (b2>0) )
    {
      arma::uvec utemp = arma::find(edge>0.75,1);
      apos = edge(b2 + utemp(0));
      iapos = b2 + utemp(0);
    }
    else
    {
      if(b==0)
      {
        if(apos>0.5)
        {
          FI1 = FI1 + (1. - FI1.max());
        }
        else
        {
          FI1 = FI1 - FI1.min();
        }
        genotype g2;
        g2.FI1 = FI1;
        g2.FI2 = FI2;
        g2.res = res;
        g2.minlen = minlen;
        g2.zeroD = zeroD;
        g2.b = 1;
        g2.farciment = farciment;
        
        g2.troba_genotypes();
        
        error = g2.error;
        genotypes = g2.genotypes;
        sc = g2.sc;
        qc = g2.qc;
        return;
      }
      else
      {
        error = 1;
        return;
        //Esta be aixo?
      }
    }
  }
  
  //Major allele homozygote cluster
  GC(0) = apos;
  if(apos>=0.7)
  {
    GC(0) = -1.;
    GC(2) = apos;
    ik = 1;
    apos = 1.- apos;
    int tempiapos = int(res) - int(iapos) - 1;
    iapos = (unsigned int)tempiapos;
    N = arma::flipud(N);
  }
  else
  {
    GC(0) = apos;
  }
  
  //Heterozygote cluster
  arma::uword np;
  //arma::uvec utemp = arma::find(edge>=(apos-(d/1000.)),1);
  //unsigned int n = utemp(0);
  unsigned int n = iapos;
  np=n;
  unsigned int resm = (res>>1) + (res%2);
  int posicio = n + 1;
  for(it = n + 1; it < res; it++)
  {
    posicio = (int)it;
    unsigned int minim = it+resm;
    minim = ((N.n_elem-1)<minim?(N.n_elem-1):minim);
    temp = N.rows(it,minim);
    (void)temp.max(np);
    if( ( (it+np-n)>=step )&&( N(it+np)>1.e-5 )&&( np>0 ) )
    {
      unsigned int tp1 = n + 1;
      unsigned int tp2 = it + np;
      double bpos = edge(tp2);      
      temp = N.rows(tp1,tp2);
      utemp = arma::find( temp == temp.min() );
      unsigned int k;
      if(utemp.n_elem > 2)
      {
        k = (int)floor(arma::median( arma::conv_to<arma::vec>::from(utemp) ));
      }
      else
      {
        k = utemp(0);
      }
      if(ik==1)
      {
        GL(1) = 1. - edge(k + n) - d;
        GC(1) = 1. - bpos;
        for(jt=0; jt<genotypes.n_elem; jt++)
        {
          if( ( FI2(jt)>zL ) && ( FI1(jt)>GL(1) ) )
          {
            genotypes(jt) = 3;
          }
        }
      }
      else
      {
        GC(1) = bpos;
        GL(0) = edge(k + n) + d;
        for(jt=0; jt<genotypes.n_elem; jt++)
        {
          if( ( FI2(jt)>zL ) && ( FI1(jt)<GL(0) ) )
          {
            genotypes(jt) = 1;
          }
        }
      }
      break;
    }
  }
  if(posicio==(int(res) - 1))
  {
    if(ik==1)
    {
      GL(1) = 1. - arma::mean( d + edge.elem(arma::find(N.rows(n, int(N.n_elem) - 1) == 0)) );
      for(it = 0; it < genotypes.n_elem; it++)
      {
        if((FI2(it)>zL) && (FI1(it)>GL(1)))
        {
          genotypes(it) = 3;
        }
      }
    }
    else
    {
      GL(0) = arma::mean( d + edge.elem(arma::find(N.rows(n, int(N.n_elem) - 1) == 0)) );
      for(it = 0; it < genotypes.n_elem; it++)
      {
        if((FI2(it)>zL) && (FI1(it)<GL(0)))
        {
          genotypes(it) = 1;
        }
      }
    }
  }
  else
  {
    unsigned int resm = (res>>1) + (res%2); //-> es necessari??
    n = posicio + np;
    posicio = n + 1;
    for(it=(n + 1); it < res; it++)
    {
      posicio = (int)it;
      unsigned int minim = it+resm;
      minim = ((N.n_elem-1)<minim?(N.n_elem-1):minim);
      temp = N.rows(it,minim);
      //unsigned int np;
      (void)temp.max(np);
      
      if( ( (it+np-n)>=step )&&( N(it+np)>1.e-5 )&&( np>0 ) )
      {
        unsigned int tp1 = n;
        unsigned int tp2 = it + np;
        double cpos = edge(tp2);
        temp = N.rows(tp1,tp2);
        //utemp = ;
        utemp = arma::find( temp == temp.min() );
        unsigned int k;
        if(utemp.n_elem > 2)
        {
          k = (int)ceil(arma::median( arma::conv_to<arma::vec>::from(utemp) ));
        }
        else
        {
          k = utemp(0);
        }
        if(ik==1)
        {
          GL(0) = 1. - edge(k + n - 1) - d;
          GC(0) = 1. - cpos;
          for(jt=0; jt<genotypes.n_elem; jt++)
          {
            if( ( FI2(jt)>zL ) && ( FI1(jt)>=GL(0) ) && ( FI1(jt)<= GL(1) ) )
            {
              genotypes(jt) = 2;
            }
            if( ( FI2(jt)>zL ) && ( FI1(jt)<GL(0) ) )
            {
              genotypes(jt) = 1;
            }
          }
        }
        else
        {
          GC(2) = cpos;
          GL(1) = edge(k + n - 1) + d;
          for(jt=0; jt<genotypes.n_elem; jt++)
          {
            if( ( FI2(jt)>zL ) && ( FI1(jt)>=GL(0) ) && ( FI1(jt)<= GL(1) ) )
            {
              genotypes(jt) = 2;
            }
            if( ( FI2(jt)>zL ) && ( FI1(jt)>GL(1) ) )
            {
              genotypes(jt) = 3;
            }
          }
        }
        break;
      }
    }
    if( posicio == (int(res) - 1))
    {
      if(ik==1)
      {
        GL(0) = 0.;
      }
      else
      {
        GL(1) = 1.;
      }
      for(it = 0; it < genotypes.n_elem; it++)
      {
        if( (FI2(it)>zL) && (FI1(it)>=GL(0)) && (FI1(it)<=GL(1)) )
        {
          genotypes(it) = 2;
        }
      }
    }
  }
  //Recomputes zero intensity threshold for each genotype cluster
  arma::vec::fixed<3> zLa;
  zLa.fill(zL);
  if((GL(0) != -1 && GL(1) != -1) && zeroD)
  {
    arma::vec::fixed<3> gtemp1;
    arma::vec::fixed<3> gtemp2;
    gtemp1(0) = 0.;
    gtemp1(1) = GL(0);
    gtemp1(2) = GL(1);
    gtemp2(0) = GL(0);
    gtemp2(1) = GL(1);
    gtemp2(2) = 1.;
    for(it = 0; it < 3; it++)
    {
      utemp = arma::find( (FI1>=gtemp1(it)) % (FI1<=gtemp2(it)) );
      if(utemp.n_elem > 10)
      {
        zLa(it) = findzeros(FI2.elem(utemp));
        for(jt = 0; jt<utemp.n_elem; jt++)
        {
          if( FI2(utemp(jt)) < zLa(it) )
          {
            genotypes(utemp(jt)) = 0;
          }
        }
      }
    }
  }
  //homozygote clusters division
  for(it=1; it<4; it = it + 2)
  {
    utemp = arma::find(genotypes == it);
    if(utemp.n_elem > 10)
    {
      arma::vec FI1temp = FI1.elem(utemp);
      if( (FI1temp.max() - FI1temp.min()) > 0.15 )
      {
        arma::vec subclust = findsubclusters(FI1temp, 4, 0.05);
        if( subclust.n_elem != 0 )
        {
          if( it==1 )
          {
            arma::uvec utemp1 = arma::find(genotypes == 3);
            arma::uvec utemp2 = utemp.elem(arma::find(FI1temp > subclust(0)));
            if( utemp1.n_elem == 0 && utemp2.n_elem > 10)
            {
              for(jt = 0; jt < genotypes.n_elem; jt++)
              {
                genotypes(jt) = (genotypes(jt)==2?3:genotypes(jt));
              }
              for(jt = 0; jt < utemp2.n_elem; jt++)
              {
                genotypes(utemp2(jt)) = 2;
              }
            }
          }
          if( it==3 )
          {
            arma::uvec utemp1 = arma::find(genotypes == 1);
            arma::uvec utemp2 = utemp.elem(arma::find(FI1temp < subclust(0)));
            if( utemp1.n_elem == 0 && utemp2.n_elem > 10)
            {
              for(jt = 0; jt < genotypes.n_elem; jt++)
              {
                genotypes(jt) = (genotypes(jt)==2?1:genotypes(jt));
              }
              for(jt = 0; jt < utemp2.n_elem; jt++)
              {
                genotypes(utemp2(jt)) = 2;
              }
            }
          }
        }
      }
    }
  }
  
  //Quality control measurement
  QC();
}

double genotype::findzeros(arma::vec I)
{
  double zeroL;
  arma::uword btemp, ktemp;
  int tmax, tmin;
  
  arma::uvec fzutemp1 = arma::find(I<1);
  if( fzutemp1.n_elem > 50 )
  {
    arma::uvec utemp = arma::find(I>0.5);
    arma::vec fzIrange;
    if(utemp.n_elem > 0)
    {
      fzIrange = sort( arma::join_cols( farciment, I.elem(arma::find( I<arma::median( I.elem(utemp) ) )) ) );
    }
    else
    {
      fzIrange = farciment;
    }
    arma::vec j = filter(diff(fzIrange));
    arma::vec temp = j.rows(1, j.n_elem - 1);
    (void)temp.max(btemp);
    int b = (int)btemp;
    tmax = 0>(b-3)?0:(b-3);
    tmin = (b+3)<((int)fzIrange.n_elem - 1)?(b+3):((int)fzIrange.n_elem - 1);
    temp = diff( fzIrange.rows( tmax, tmin ) );
    (void)temp.max(ktemp);
    int k = (int)ktemp;
    tmax = 0>(b-3+k)?0:(b-3+k);
    tmin = tmax<((int)fzIrange.n_elem - 1)?tmax:((int)fzIrange.n_elem - 1);
    zeroL = 1.01*fzIrange(tmin);
  }
  else
  {
    zeroL = 0.;
  }
  return zeroL;
}

arma::vec genotype::findsubclusters(arma::vec BAF, int i, double n)
{
  arma::vec c = generaRang(BAF.min(), BAF.max(), 0.02);
  arma::uvec H = arma::histc(BAF, c);
  arma::vec Hd = arma::conv_to<arma::vec>::from(H);
  Hd = Hd/arma::sum(Hd);
  arma::uvec X;
  arma::vec Y;
  findpeaks(Hd, n, i, -1, Y, X);
  arma::uvec P = recfp(Y, X, Hd);
  return c.elem(P);
}

arma::uvec genotype::recfp(arma::vec Y, arma::uvec X, arma::vec H)
{
  arma::uvec P;
  if(Y.n_elem>1)
  {
    for(unsigned int i=1;i<Y.n_elem;i++)
    {
      arma::vec temp = H.rows(X(i-1),X(i));
      arma::uword m1, m2;
      (void)temp.min(m1);
      temp = Y.rows(i-1,i);
      double llindar = 0.3*temp.min(m2);
      if( H( X(i-1)+m1 ) < llindar )
      {
        P.insert_rows(P.n_elem,1, false);
        P(P.n_elem-1) = X(i-1)+m1;
      }
      else
      {
        Y.shed_row(i-1+m2);
        X.shed_row(i-1+m2);
        P = arma::join_cols(P, recfp(Y, X, H));
      }
      
    }
  }
  return P;
}

arma::vec genotype::diff(arma::vec v)
{
  arma::vec result = arma::vec(v.n_elem - 1);
  for (unsigned int i = 0; i<v.n_elem-1; i++)
  {
    result(i) = v(i+1) - v(i);
  }
  return result;
}

arma::vec genotype::filter(arma::vec v)
{
  if(v.n_elem >= 3)
  {
    arma::vec result = arma::vec(v.n_elem - 2);
    for (unsigned int i = 0; i<v.n_elem-2; i++)
    {
      result(i) = (v(i) + v(i+1) + v(i+2))/3.;
    }
    return result;
  }
  else
  {
    return v;
  }
}

void genotype::QC()
{
  qc = 0.;
  sc = arma::zeros(FI1.n_elem);
  arma::uvec n1 = find(genotypes==1);
  arma::uvec n2 = find(genotypes==2);
  arma::uvec n3 = find(genotypes==3);
  int N1 = (n1.n_elem == 0)?0:1;
  int N2 = (n2.n_elem == 0)?0:1;
  int N3 = (n3.n_elem == 0)?0:1;
  
  double Mean1 = 0.;
  double Mean2 = 0.;
  double Mean3 = 0.;
  if(N1 == 1)
  {
    Mean1 = arma::mean(FI1.elem(n1));
  }
  if(N2 == 1)
  {
    Mean2 = arma::mean(FI1.elem(n2));
  }
  if(N3 == 1)
  {
    Mean3 = arma::mean(FI1.elem(n3));
  }
  /*arma::vec Std1 = arma::stddev(FI1.elem(n1));
  arma::vec Std2 = arma::stddev(FI1.elem(n2));
  arma::vec Std3 = arma::stddev(FI1.elem(n3));*/
  double S1 = -1.;
  double S2 = -1.;
  double S3 = -1.;
  
  int Ntotal = N1 + N2 + N3;
  double qq1, qq2, qq3;
  if(Ntotal < 2)
  {
    qq1 = 0.5;
    qq3 = 0.5;
  }
  else if(Ntotal == 2)
  {
    if(N1 == 1)
    {
      if( N2 == 1)
      {
        //Mean1 = arma::mean(FI1.elem(n1));
        //Mean2 = arma::mean(FI1.elem(n2));
        qq1 = Mean2 - Mean1;
        qq3 = qq1;
      }
      else
      {
        //Mean1 = arma::mean(FI1.elem(n1));
        //Mean3 = arma::mean(FI1.elem(n3));
        qq1 = Mean3 - Mean1;
        qq3 = qq1;
      }
    }
    else
    {
      //Mean2 = arma::mean(FI1.elem(n2));
      //Mean3 = arma::mean(FI1.elem(n3));
      qq1 = Mean3 - Mean2;
      qq3 = qq1;
    }
  }
  else
  {
    //Mean1 = arma::mean(FI1.elem(n1));
    //Mean2 = arma::mean(FI1.elem(n2));
    //Mean3 = arma::mean(FI1.elem(n3));
    qq1 = Mean2 - Mean1;
    qq3 = Mean3 - Mean1;
  }
  qq2 = (qq1 < qq3)?qq1:qq3;
  
  int SumaS = 0;
  double MitjaS = 0.;
  if(N1 == 1)
  {
    for(unsigned int it = 0; it < n1.n_elem; it++)
    {
      double temp = 1. - ( fabs(FI1( n1(it) ) - Mean1)/qq1 );
      temp = temp>0.?temp:0.;
      sc(n1(it)) = temp;
    }
  }
  if(n1.n_elem > 1)
  {
    S1 = 10.*arma::stddev(FI1.elem(n1));
    if(S1>=0.)
    {
      SumaS = SumaS + 1;
      MitjaS = MitjaS + S1;
    }
  }
  if(N2 == 1)
  {
    for(unsigned int it = 0; it < n2.n_elem; it++)
    {
      double temp = 1. - ( fabs(FI1( n2(it) ) - Mean2)/qq2 );
      temp = temp>0.?temp:0.;
      sc(n2(it)) = temp;
    }
  }
  if(n2.n_elem > 1)
  {
    S2 = 10.*arma::stddev(FI1.elem(n2));
    if(S2>=0.)
    {
      SumaS = SumaS + 1;
      MitjaS = MitjaS + S2;
    }
  }
  if(N3 == 1)
  {
    for(unsigned int it = 0; it < n3.n_elem; it++)
    {
      double temp = 1. - ( fabs(FI1( n3(it) ) - Mean3)/qq3 );
      temp = temp>0.?temp:0.;
      sc(n3(it)) = temp;
    }
  }
  if(n3.n_elem > 1)
  {
    S3 = 10.*arma::stddev(FI1.elem(n3));
    if(S3>=0.)
    {
      SumaS = SumaS + 1;
      MitjaS = MitjaS + S3;
    }
  }
  
  if(SumaS>0)
  {
    MitjaS = (double)(MitjaS / ((double)SumaS));
    MitjaS = (MitjaS<2.)?MitjaS:2.;
    qc = 1. - (MitjaS/2.);
  }
}