#ifndef GENOTYPE_H
#define GENOTYPE_H

#include <cmath>
#include <armadillo>
#include "options.h"
#include "misc.h"

using namespace std;

extern opcions o;

class genotype
{
  public:
  arma::vec FI1;
  arma::vec FI2;
  unsigned int res;
  double minlen;
  bool zeroD;
  bool b;
  
  arma::vec farciment; //vector 0->0.2 step 0.001
  bool error;
  
  arma::ivec genotypes;
  arma::vec sc;
  double qc;
  
  void troba_genotypes();
  double findzeros(arma::vec I);
  arma::vec findsubclusters(arma::vec BAF, int i, double n);
  arma::uvec recfp(arma::vec Y, arma::uvec X, arma::vec H);
  arma::vec diff(arma::vec v);
  arma::vec filter(arma::vec v);
  void QC();
  

};

#endif