#ifndef LOCUS_H
#define LOCUS_H

#include <iostream>
#include <string>
#include <sstream>
#include <cstring>
#include <cmath>
#include <armadillo>
#include "misc.h"
#include "options.h"
#include "genotype.h"
#include "cnvscoring.h"

using namespace std;

extern opcions o;

class locus
{
public:
  string nom;
  string chr;
  int posicio;

  int nindividusRaw;
  int nindividus;

  arma::vec vectorRawA;
  arma::vec vectorRawB;
  arma::vec vectorRawF;
    
  arma::vec vectorA;
  arma::vec vectorB;
  arma::vec vectorF;
  
  arma::uvec filtre;

  cnvscoring cnv;
  genotype gt;
  
  arma::ivec rgenotypes;
  arma::vec rgSC;
  arma::vec rSC;
  double rqc;
  
  locus(int nRaw, int n);
  ~locus();

  void carregaDades(ifstream & fitxer, arma::uvec & outliers, ofstream & fgenotypes, ofstream & fgscores, ofstream & fcnvscores, ofstream & flog);
  double findnormal(arma::vec v);
  void refind(arma::vec bafprev, arma::vec & vAprev, arma::vec & vBprev, arma::uvec & elements);
  void escriu_genotype(ofstream & fitxer);
  void escriu_genotype_sc(ofstream & fitxer);
  void escriu_cnvscores(ofstream & fitxer);
};

#endif
