#include "main.h"

#define OUTPRECISION 4

opcions o;

int main(int argc, char* argv[])
{
  string f;
  ifstream fitxer;
  ifstream foutliers;
  ofstream fgenotypes;
  ofstream fgscores;
  ofstream fcnvscores;
  ofstream flog;
  vector<string> individus;
  vector<string> individus2;
  arma::uvec outliers;
  //vector<individusType> individus;

  escriuCapcalera();
  
  itpp::it_disable_warnings();
  
  o.setDefaults();
  o.agafaOpcions(argc, argv);

  if(o.f_outliers!="")
  {
    comprovaExistenciaFitxer(o.f_outliers, foutliers);
    llegeixOutliers(individus, outliers, foutliers);
    foutliers.close();
  }

  comprovaExistenciaFitxer(o.f_IN, fitxer);
  llegeixIndividus(individus, outliers, fitxer);

  //////////////////////////////////////////////////
  //Open genotype results file
  fgenotypes.open(o.f_genotypes.c_str(),ofstream::out);
  fgenotypes.precision(OUTPRECISION);
  fgenotypes << "SNP CHR BP QC";
  for(unsigned int it=0; it<outliers.n_elem; it++)
  {
    fgenotypes << " " << individus[outliers(it)];
  }
  fgenotypes << std::endl;
  
  //////////////////////////////////////////////////
  //Open genotype scores file
  fgscores.open(o.f_gscores.c_str(),ofstream::out);
  fgscores.precision(OUTPRECISION);
  fgscores << "SNP";
  for(unsigned int it=0; it<outliers.n_elem; it++)
  {
    fgscores << " " << individus[outliers(it)];
  }
  fgscores << std::endl;
  
  //////////////////////////////////////////////////
  //Open cnv results file
  if( o.og == 0 )
  {
    fcnvscores.open(o.f_cnvscores.c_str(),ofstream::out);
    fcnvscores.precision(OUTPRECISION);
    fcnvscores << "ID CHR BP NC MaxRat";
    for(unsigned int it=0; it<outliers.n_elem; it++)
    {
      fcnvscores << " " << individus[outliers(it)];
    }
    fcnvscores << std::endl;
  }
  
  //////////////////////////////////////////////////
  //Open log file
  flog.open(o.f_log.c_str(),ofstream::out);
  flog.precision(OUTPRECISION);
  
  //////////////////////////////////////////////////
  //Start main loop
  locus l(individus.size(), outliers.n_elem);
  
  while(!fitxer.eof())
  {
    l.carregaDades(fitxer, outliers, fgenotypes, fgscores, fcnvscores, flog);
  }


  
  //////////////////////////////////////////////////
  //Close opened files
  fitxer.close();
  fgenotypes.close();
  fgscores.close();
  flog.close();
  if( o.og == 0)
  {
    fcnvscores.close();
  }
  
  std::cout << std::endl << "The analysis has ended successfully." << std::endl;

}
