#include "misc.h"

void comprovaExistenciaFitxer(string f, ifstream & test)
{
  //ifstream test;
  //int r;
  
  //r = 0;
  test.open(f.c_str(), ifstream::in);
  if(test.fail())
  {
    test.clear(ios::failbit);
    test.close();
    string e = "Error: The file [ " + f + " ] does not exist.";
    escriuError(e);
    //r = 1;
  }
  //test.close();
  //return r;
  //return test;
}

void escriuCapcalera()
{
  std::cout << "@------------------------------------------@" << std::endl;
  std::cout << "|       GStream       | v1.00 | 01/10/2012 |" << std::endl;
  std::cout << "|------------------------------------------|" << std::endl;
  std::cout << "| (C) 2012 Grup de Recerca de Reumatologia |" << std::endl;
  std::cout << "|------------------------------------------|" << std::endl;
  std::cout << "|      GNU General Public License, v2      |" << std::endl;
  std::cout << "|------------------------------------------|" << std::endl;
  std::cout << "|            http://www.urr.cat            |" << std::endl;
  std::cout << "@------------------------------------------@" << std::endl << std::endl;
}

void escriuError(string e)
{
  std::cout << "**********************************" << std::endl;
  std::cout << e << std::endl;
  std::cout << "**********************************" << std::endl;
  exit(1);
}

void llegeixIndividus(vector<string> & individus, arma::uvec & outliers, ifstream & fitxer)
{
  string linia;
  string word;
  unsigned int flag = 0;
  vector<int> outlierstemp;
  
  getline(fitxer, linia);
  istringstream linestream(linia);
  
  linestream >> word;
  linestream >> word;
  linestream >> word;

  if(individus.size()!=0)
  {
    unsigned int i = 0;
    while (linestream >> word)
    {
      if(flag == 0)
      {
        word.erase(word.end()-2, word.end());
        if(i >= individus.size())
        {
          escriuError("Error: there are less individuals in the outliers file than in the input file.");
        }
        if(individus[i] != word)
        {
          std::cout << "Position: " << i << " " << individus[i] << " != " << word << std::endl;
          escriuError("Error: the individuals of the outliers file are unequal or in a different order than the individuals of the input file.");
        }
        i = i + 1;
      }
      flag = (flag + 1) % 2;
    }
  }
  else
  {
    while (linestream >> word)
    {
      if(flag == 0)
      {
        word.erase(word.end()-2, word.end());
        individus.push_back(word);
        outlierstemp.push_back(1);
      }
      flag = (flag + 1) % 2;
    }
    outliers = arma::find(arma::conv_to<arma::uvec>::from(outlierstemp) == 1);
  }
  if(flag == 1)
  {
    escriuError("Error: The input file is not properly formated.");
  }
}

void llegeixOutliers(vector<string> & individus, arma::uvec & outliers, ifstream & foutliers)
{
  string linia;
  string ind;
  int status;
  vector<unsigned int> outlierstemp;

  while (getline(foutliers, linia))
  {
    istringstream linestream(linia);
    linestream >> ind;
    if ((linestream >> status).fail())
    {
      std::cout << "Individual: " << ind << std::endl;
      escriuError("Error: The outliers file is not properly formated.");
    }
    individus.push_back(ind);
    outlierstemp.push_back(status);
  }
  outliers = arma::find(arma::conv_to<arma::uvec>::from(outlierstemp) != 0);
}

double round(double r) {
  return (r > 0.0) ? floor(r + 0.5) : ceil(r - 0.5);
}

arma::vec generaRang(double inici, double final, double pas)
{
  unsigned int n = (unsigned int)floor((final-inici)/pas);
  n = n + 1;
  if(( ((double(n)*pas) + inici) + 1e-6>= final ) && ( ((double(n)*pas) + inici) - 1e-6<= final ))
  {
    n = n + 1;
  }
  arma::vec resultat = arma::vec(n);
  resultat(0) = inici;
  for(unsigned int i = 1; i<n; i++)
  {
    resultat(i) = resultat(i-1) + pas;
  }
  return resultat;
}

void findpeaks(arma::vec DataRaw, double Ph, int Pd, int npks, arma::vec & pks, arma::uvec & locs)
{
  // init
  int m = -1;
  arma::vec Data = arma::vec(DataRaw.n_elem + 2);
  Data(0) = 0.;
  for(unsigned int it = 0; it < DataRaw.n_elem; it++)
  {
    Data(it + 1) = DataRaw(it);
  }
  Data(DataRaw.n_elem + 1) = 0.;
  
  int Np= Data.n_elem;
  int endL = -1;
  int endR = -1;
  //int prevPeakBoundL;
  arma::uvec temp;
  arma::uvec rangL, rangR;
  double valor;
  // pre-allocate for speed
  pks  = arma::zeros<arma::vec>(Np);
  locs = arma::zeros<arma::uvec>(Np);
  // bucle
  int j = 1;
  while (j < Np - 1) {
    if (Data(j) < Ph) { j++; continue;}
    valor = Data(j);
    endL = 0 > (j-Pd) ? 0:(j-Pd);
    // rightmost neighbor index
    endR = (Np-1) > (j + Pd) ? (j + Pd):(Np-1);
    // create neighbor data set
    arma::vec rang = Data.rows(endL,endR);
    // set current data point to -Inf in the neighbor data set
    rang(j-endL) = -1;
    // Compare current data point with all neighbors
    temp = arma::find(rang <= valor);
    if (temp.n_elem== rang.n_elem){
      rangL = arma::find(Data.rows(endL,j - 1) < valor);
      rangR = arma::find(Data.rows(j + 1, endR) <= valor);
      if((rangL.n_elem>0) && (rangR.n_elem>0))
      {
        m = m+1;
        locs(m) = j-1;
        pks(m)  = valor;
        j = j + Pd + 1;
      }
      else
      {
        j++;
      }
    }
    else
    {
      j++;
    }
  }
  if(m==-1)
  {
    pks.reset();
    locs.reset();
    return;
  }
  if( (m-1 > npks) && (npks != -1) )
  {
    pks  = pks.rows(0,npks);
    locs = locs.rows(0,npks);
  }
  else
  {
    pks  = pks.rows(0,m);
    locs = locs.rows(0,m);
  }
}
