#include "options.h"

void opcions::setDefaults()
{
  f_IN = "";
  f_outliers = "";
  f_genotypes = "GStream.snp";
  f_gscores = "GStream.snp.sc";
  f_cnvscores = "GStream.cnv";
  f_log = "GStream.log";
  
  sens = 1.e-4;
  mhc = 1;
  mic = 0.1;
  mac = 0.3;
  res = 40;
  
  gqt = 0.;
  stdcnp = 8.;
  
  og = 0;
  
  zeroD = 1;
}

void opcions::escriuAjuda()
{
  std::cout << "Usage: GStream --input <source file> [OPTIONS]" << std::endl << std::endl;
  std::cout << "Available options:" << std::endl << std::endl;
  std::cout << "  --goutput <file>: Defines the SNP genotypes output file (default=GStream.snp)." << std::endl;
  std::cout << "  --cnvoutput <file>: Defines the CNV scores output file (default=GStream.cnv)." << std::endl;
  std::cout << "  --outliers <file>: Defines the outliers file." << std::endl;
  std::cout << "  --og: Computes only genotypes." << std::endl;
  std::cout << "  --noz: Turns off homozygous deletion detection (--og turns on automatically)." << std::endl;
  std::cout << "  --gqt X: Sets the quality score threshold for genotyping. X is a floating point number (default=0)." << std::endl;
  std::cout << "  --stdcnp X: Minimum distance (number of STDs) to call amplifications/deletions under the one component mode. X is a floating point number (default=8)." << std::endl;
  std::cout << "  --res N: Sets the number of BAF bins used for density estimation. N is an integer number (default=40)." << std::endl;
  exit(0);
}

void opcions::agafaOpcions(int argc, char* argv[])
{
  int fi, fog, focnv;
  
  fi = 0;
  fog = 0;
  focnv = 0;

  for (int i = 1; i < argc; i++) 
  {
    if ( !strcmp(argv[i],"--help") )
    {
      escriuAjuda();
    }
  }
  
  std::cout << "Options in effect:" << std::endl;
  for (int i = 1; i < argc; i++) 
  {
    if ( !strcmp(argv[i],"--input") )
    {
      if (i + 1 < argc)
      {
        f_IN.assign(argv[i + 1]);
        std::cout << "\t" << argv[i] << " " << f_IN << std::endl;
        fi = 1;
      }
    }
    else if (!strcmp(argv[i],"--outliers"))
    {
      if (i + 1 < argc)
      {
        f_outliers.assign(argv[i + 1]);
        std::cout << "\t" << argv[i] << " " << f_outliers << std::endl;
      }
    }
    else if (!strcmp(argv[i],"--goutput"))
    {
      if (i + 1 < argc)
      {
        f_genotypes.assign(argv[i + 1]);
        std::cout << "\t" << argv[i] << " " << f_genotypes << std::endl;
        f_gscores = f_genotypes;
        f_gscores.append(".sc");
        fog = 1;
      }
    }
    else if (!strcmp(argv[i],"--cnvoutput"))
    {
      if (i + 1 < argc)
      {
        f_cnvscores.assign(argv[i + 1]);
        std::cout << "\t" << argv[i] << " " << f_cnvscores << std::endl;
        focnv = 1;
      }
    }
    else if (!strcmp(argv[i],"--gqt"))
    {
      if (i + 1 < argc)
      {
        stringstream ss(argv[i + 1]);
        if( (ss >> gqt).fail() )
        {
          escriuError("Error: The --gqt parameter is not a valid number. \nScientific notation can be used (e.g. 1e-2).");
        }
        std::cout << "\t" << argv[i] << " " << gqt << std::endl;
      }
    }
    else if (!strcmp(argv[i],"--stdcnp"))
    {
      if (i + 1 < argc)
      {
        stringstream ss(argv[i + 1]);
        if( (ss >> stdcnp).fail() )
        {
          escriuError("Error: The --stdcnp parameter is not a valid number. \nScientific notation can be used (e.g. 1e-2).");
        }
        std::cout << "\t" << argv[i] << " " << stdcnp << std::endl;
      }
    }
    else if (!strcmp(argv[i],"--res"))
    {
      if (i + 1 < argc)
      {
        stringstream ss(argv[i + 1]);
        if( (ss >> res).fail() )
        {
          escriuError("Error: The --res parameter is not a valid number.");
        }
        std::cout << "\t" << argv[i] << " " << res << std::endl;
      }
    }
    else if (!strcmp(argv[i],"--og"))
    {
      og = 1;
      std::cout << "\t" << argv[i] << std::endl;
    }
    else if (!strcmp(argv[i],"--noz"))
    {
      zeroD = 0;
      std::cout << "\t" << argv[i] << std::endl;
    }
    else
    {
      if(!strncmp(argv[i],"--",2))
      {
        std::cout << "\t" << argv[i] << " is not a valid option. It will be ignored." << std::endl;
      }
    }
  }
  std::cout << std::endl;
  if(fi == 0)
  {
    escriuError("Error: No input file is specified. Please, use the option --input to specify the input file.");
  }
  if(fog == 0)
  {
    std::cout << "No output file specified. Using the default [ GStream.snp ]" << std::endl;
  }
  if(focnv == 0 && og == 0)
  {
    std::cout << "No output file specified. Using the default [ GStream.cnv ]" << std::endl;
  }
  if(og == 0 and zeroD == 0)
  {
    og = 1;
    std::cout << "Flag --noz has turned on. Flag --og is also turned on." << std::endl;
  }
  std::cout << std::endl;
}
