PMA <- function(dat, pheno, covar=NULL, pathout=".", genesetpath=".",
                minNgenes = 10, maxNgenes = 300, annotation.data.frame = NULL,
                P.thresh=0.05, maxN=5, NPERM=100, P_THRESH=0.01, R_THRESH = 0.2,
                distCPG = 500,skipPermuting=TRUE, verbose=TRUE ){

  stopifnot(is.numeric(dat))
  n <- length(pheno)
  if (n != ncol(dat))
    stop("length of pheno does not equal number of samples in dataset")
  intrcpt <- rep(1, length(pheno))
  X <- cbind(intrcpt, pheno)
  if(!is.null(covar)){
    stopifnot(is.numeric(covar))
    if (n != nrow(covar))
      stop("covariate matrix does not match number of samples")
    else{
      X <- cbind(X, covar)
    }
  }

  if(is.null(annotation.data.frame)){
    stop("missing annotation file")
  }
  else{
    Gene_Names <- as.character(annotation.data.frame$Gene)
    CHR <- as.character(annotation.data.frame$chr)
    BP <- annotation.data.frame$bp
  }
  ##### Open output file
  fileConn <- file(pathout, "w")
  header <-  c("pathway", "NGenes", "NProbes", "Pori", "Pperm", "Genes")
  header <- paste(header, collapse="\t")
  writeLines(header, fileConn)
  ##### Get pathways and filter for gene number.
  PATHWAYS <- list()
  con_ddbb <- file(genesetpath, "r")
  ddbb <- readLines(con_ddbb)
  selectedPathways <- list()
  for(pwy in ddbb){
    pwy.x <- strsplit(pwy, split="\t")[[1]]
    pwy.name    <- pwy.x[1]
    pwy.genes <- pwy.x[-1]
    if(length(pwy.genes) < minNgenes | length(pwy.genes) > maxNgenes) next()
    selectedPathways[[pwy.name]] <- pwy.genes
  }
  print(paste(length(selectedPathways), " pathways selected from ", length(ddbb), " available.", sep=""))
  close(con_ddbb)
  ##### Pathway association analysis
  RESDDBB <- NULL
  for(pwy in names(selectedPathways)){
    print(paste("Performing pathway:", pwy))
    pwy.genes <- selectedPathways[[pwy]]
    print(paste("Number of genes:", length(pwy.genes)))
    ipwy.genes <- NULL
    for(gene in pwy.genes){
      iprobes <- which(Gene_Names == gene)
      ipwy.genes <- c(ipwy.genes, iprobes)
    }
    print(paste("Number of probes:", length(ipwy.genes)))
    # Calculate original statistic (filtering for distance and correlation).
    n <- nrow(X)
    k <- ncol(X)
    Pori <- apply(dat[ipwy.genes,],1,fitlm, X, n, k)
    probe.cor <- cor(t(dat[ipwy.genes,]), use="pairwise.complete.obs")
    chr.pwy <- CHR[ipwy.genes]
    bp.pwy <-  BP[ipwy.genes]
    isig <- which(Pori < P.thresh)
    if(length(isig) == 0) next()
    osig <- order(Pori[isig])
    opval <- Pori[isig][osig]
    ochr <- chr.pwy[isig][osig]
    obp  <- bp.pwy[isig][osig]
    onames <- names(opval)
    for(i in 1:length(opval)){
      pval.pwy <- opval[i]
      if(is.na(pval.pwy)) next()
      chr.cpg <- ochr[i]
      bp.cpg<- obp[i]
      dist.cpg <- abs(bp.cpg- obp)
      iclose <- which(ochr == chr.cpg & dist.cpg > 0 & dist.cpg < distCPG)
      if(length(iclose) > 0) {
        cor.cpg <- probe.cor[onames[i], onames[iclose]]
        names(cor.cpg) <- onames[iclose]
        isup  <- which(cor.cpg > R_THRESH)
        noms_sup <- names(cor.cpg)[isup]
        opval[noms_sup] <- NA
      }
    }
    sigPori <- opval[which(!is.na(opval))]
    if(length(sigPori) > maxN) sigPori <- sort(sigPori)[1:maxN]
    mPori <- mean(sigPori)
    print(paste(pwy, mPori))
    # Prevent permuting non-significant pathways
    if(skipPermuting & mPori > P_THRESH){
      print("skipping permutation analysis...")
      next()
    }
    PVALS <- NULL
    lon <- length(pheno)
    ixs <- sample(1:length(pheno), lon, replace=F)
    print("starting permutations...")
    for(n in 1:NPERM){
      ixs <- sample(ixs, lon, replace=F)
      Pperm <- apply(dat[ipwy.genes,],1, fitlm_perm, X, n, k, ixs)  #
      isig <- which(Pperm < P.thresh)
      if(length(isig) == 0) mPperm <- 1
      else{
        osig <- order(Pperm[isig])
        opval <- Pperm[isig][osig]
        ochr <- chr.pwy[isig][osig]
        obp  <- bp.pwy[isig][osig]
        onames <- names(opval)

        for(i in 1:length(opval)){
          pval.pwy <- opval[i]
          if(is.na(pval.pwy)) next()
          chr.cpg <- ochr[i]
          bp.cpg<- obp[i]
          dist.cpg <- abs(bp.cpg- obp)
          iclose <- which(ochr == chr.cpg & dist.cpg > 0 & dist.cpg < distCPG)
          if(length(iclose) > 0) {
            cor.cpg <- probe.cor[onames[i], onames[iclose]]
            names(cor.cpg) <- onames[iclose]
            isup  <- which(cor.cpg > R_THRESH)
            noms_sup <- names(cor.cpg)[isup]
            opval[noms_sup] <- NA
          }
        }
        sigPperm <- opval[which(!is.na(opval))]
        if(length(sigPperm) > maxN) sigPperm <- sort(sigPperm)[1:maxN]
        mPperm <- mean(sigPperm)
      }
      PVALS <- c(PVALS, mPperm)
    }
    Pval <- (length(which(PVALS < mPori)) + 1) / (NPERM + 1)
    print(paste("Permuted P-value: ", Pval))
    newline <- c(pwy, length(pwy.genes), length(ipwy.genes), mPori, Pval, paste(pwy.genes, collapse="/"))
    newline <- paste(newline, collapse="\t")
    writeLines(newline, fileConn)
  }
  close(fileConn)
}

