fastlm <- function(Y, X, n, k){
  bh <- solve(t(X)%*%X)%*%t(X)%*%Y
  res <- Y - X %*% bh
  VCV = 1/(n-k) * as.numeric(t(res)%*%res) * solve(t(X)%*%X)
  StdErr <- sqrt(diag(VCV))
  pval <- 2*pt(abs(bh/StdErr),df=n-k,lower.tail=FALSE)
  return(pval)
}
