\name{PMA}
\alias{PMA}
\title{Find differentially methylated pathways}
\description{
Determine association between methylation pattern in a pathway (or any other gene-set) and a phenotype.
}
\usage{
PMA <- function(dat, pheno, covar=NA, pathout=".", genesetpath=".", minNgenes = 10, maxNgenes = 300,
                annotation=".", P.thresh=0.05, maxN=5, NPERM=100, P_THRESH=0.01, R_THRESH = 0.2, distCPG = 500,
                skipPermuting=TRUE, verbose=TRUE )
}
\arguments{
  \item{dat}{Matrix with methylation levels (Beta), columns are individuals and rows are CpG sites.}
  \item{pheno}{Phenotype to be tested (numeric vector).}
  \item{pathout}{Path to output file.}
  \item{genesetpath}{Path to file with gene set descriptions.}
  \item{minNgenes}{Minimum number of genes to include a pathway.}
  \item{maxNgenes}{Maximum number of genes to include a pathway.}
  \item{annotation}{Data.frame with CpG to gene annotation.}
  \item{P.thresh}{Significance threshold for CpGs within a pathway.}
  \item{maxN}{Maximum number of significant CpGs to include.}
  \item{NPERM}{Number of permutations.}
  \item{P_THRESH}{Significance threshold of the original pathway to start permutations.}
  \item{R_THRESH}{Correlation threshold to discard neighboring correlated CpGs.}
  \item{distCPG}{Distance (pb) at which neighboring CpGs are examined for correlation.}
  \item{skipPermuting}{Skip permutation if original pathway P-value does not fulfill threshold.}
  \item{verbose}{A boolean to print out messages}
}
\examples{
library("PMA")
data("Anot450k_flank2kb")
# load toy dataset
library("FlowSorted.Blood.450k")
data(FlowSorted.Blood.450k)
B <- getBeta(FlowSorted.Blood.450k)
# Test pathway differential methylation between CD19+ B cells and rest of cell types.
pheno <- rep(0, ncol(B))
pheno[grep("CD19", colnames(B))] <- 1
# Output file name
pathout <- "CD19_PMAs.txt"
# Path for file with pathway gene listings
genesetpath <- "data/biocarta_small.txt"
# Run PMA
PMA(B, pheno, covar=NULL, pathout=pathout, genesetpath=genesetpath,
       minNgenes = 10, maxNgenes = 300, annotation.data.frame = Anot450k_flank2kb,
       P.thresh=0.05, maxN=20, NPERM=100, P_THRESH=0.01, R_THRESH = 0.2,
       distCPG = 500,skipPermuting=TRUE, verbose=TRUE )
}

\author{
  Antonio Juli; \email{toni.julia@vhir.org}.
}
