`CN.stream` <-
function(f_data, output_path, norm_plate = -1,
         status = -1, verbose = 0, option = -1){
options(warn = -1)
f_score    <- paste(output_path,"/CNstream_scores.txt",sep="")
f_test_seg <- paste(output_path,"/CNstream_CNPseg.txt",sep="")
##f_test_snp <- paste(output_path,"/CNstream_marker.txt",sep="")
cat("\n********************************************************\n")
cat("********************************************************\n")
cat("Analysis started at", date(), "\n\tInput data file (X, Y):\t", f_data,
    "\n\tCopy number scores:\t", f_score, "\n\tSegment calls:\t\t", f_test_seg,"\n")     

################################
### PARSING & INITIALIZATION ###
################################

if ((typeof(option)=="list")=="FALSE"){
    option <- list(segment_length = 1e5, fr = 1, LS = 2.7, LI = 1.65,
                   nmarkers = 5, minmarkers = 3, pdfplot = -1)
} else{
    if (all("segment_length"!=names(option))) option$segment_length = 1e5
    if (all("fr"!=names(option))) option$fr <- 1
    if (all("LS"!=names(option))) option$LS <- 2.7
    if (all("LI"!=names(option))) option$LI <- 1.65
    if (all("nmarkers"!=names(option))) option$nmarkers <- 5
    if (all("minmarkers"!=names(option))) option$minmarkers <- 3
    if (all("pdfplot"!=names(option))) option$pdfplot <- -1
}
data   <- file(f_data, "r")
header <- readLines(data, 1)
dat    <- strsplit(header, "\t")[[1]]
dat    <- dat[seq(4, length(dat), 2)]
dat    <- sub(".X","",dat)
L      <- length(dat)
fscore <- file(f_score, "w")
ftest  <- file(f_test_seg, "w")
## Check file containing sample plate numbers
if(norm_plate == -1) {
    plates <- matrix(1, L, 1)
} else {
    plates <- read.table(norm_plate)
}
inputs <- which(plates != 0)
plates <- plates[, 1]
## Create Case/Control vectors
if(status != -1) {
    ##ftest2 <- file(f_test_snp, "w")
    status  <- read.table(status)
    if (length(dat) != dim(status)[1]){
        cat("Error: Number of samples of the input data file and status file doesn't match\n")
        return(0)
    }
    ##cat("\tPer-marker assoc. test:\t", f_test_snp, "\n")
    status  <- status[inputs, 1]
    cases   <- which(status == 1)
    controls<- which(status == 0) 
}

if (length(dat) != length(plates)){
    cat("Error: Number of samples of input data file and plate file doesn't match\n")
    return(0)
} else{
    if (length(status)>1) cat("\tNumber of samples:\t", length(inputs),"\t(",length(cases),"cases /",length(controls),"controls)\n")
    else                  cat("\tNumber of samples:\t", length(inputs),"\n")
    cat("********************************************************\n")
    cat("********************************************************\n\n")
}
dat    <- dat[inputs]
LT     <- length(dat)
## Write header output files
cat("Name", "Chr", "Position", dat, "\n", sep = "\t", file = fscore)
if (length(status) < 2) cat("CHROM", "BP_INIT", "BP_END", "%AMPS", "%DELS", dat, "\n", sep="\t", file = ftest)
else {
    cat("CHROM", "BP_INIT", "BP_END", "P-Value", "OR", "%A_CASES","%D_CASES", "%A_CONTROLS", "%D_CONTROLS", dat, "\n", sep = "\t", file = ftest)
    ##cat("CHROM", "BASEPAIR", "MARKER", "P-Value", "OR", "CNV_TYPE", "%CASES", "%CONTROLS", "\n", sep = "\t", file = ftest2)
}
##Time initialization
time_   <- proc.time()
counter <- 0
##Create init variables
chr_ant <- 0
i       <- -1
RES     <- matrix(0, 1, LT)
ST      <- matrix(0, option$nmarkers, LT + 1)
if( option$pdfplot != -1 ) IT <- matrix(0,2*option$nmarkers,LT)

##########################################
### MAIN LOOP OVER EACH DATA FILE LINE ###
##########################################

while (1){
    ##ReadLine parsing
    i     <- i + 1
    dat   <- readLines(data, 1)
    if(length(dat) == 0) break
    dat   <- sub(",",".",strsplit(dat, "\t")[[1]])
    snp   <- dat[1]
    chr   <- dat[2]
    bpr   <- dat[3]
    ##########################################
    ##Segment CNV analysis if conditions OK ## --> At least 5 consecutive probes analyzed
    ########################################## --> Distance between firs and last probe shorter than option$segment_length

    if ((sum(ST[, 1] == 0) == 0) && (max(ST[, 1]) - min(ST[, 1]) < option$segment_length)){
        RES[] <- 0
        RES[1, which(apply(ST[, 2:(LT + 1)] < option$LI, 2, sum) >= option$minmarkers)] <- -1       ##DELETIONS
        RES[1, which(apply(ST[, 2:(LT + 1)] > option$LS, 2, sum) >= option$minmarkers)] <- +1       ##AMPLIFICATIONS
        CN    <- c(100 * length(which(RES[1, ] == 1)) / LT, 100*length(which(RES[1, ] == -1)) / LT) ## % AMPLIFICATIONS & DELETIONS
        if((CN[1] + CN[2]) > option$fr) { ##Check if CNV frequency higher than the specified threshold
            ##Sample status provided? Case/Control analysis?
            segment.analysis(chr_ant, ST, RES, LT, option, status, cases, controls, ftest)
            ##OUTPUT FIGURES SELECTED?
            if( option$pdfplot != -1 ){
                segment.plot(output_path, chr_ant, RES, ST, IT, option)
            }
            counter <- counter + 1
        }
    }

    ##########################################
    ## Probe analysis                       ##
    ##########################################

    ##Check if new chromosome
    if (as.numeric(chr) != chr_ant){
        ST[] <- 0
        if( option$pdfplot != -1 ) IT[] <- 0
    }
    ST[i%%option$nmarkers+1, 1] <- as.numeric(bpr)
    if(verbose != 0)      cat("Processing probe number ", i, ":", snp,"in chromosome", chr, "basepair", bpr, "\n")
    else if(i%%1000 == 0) cat("\r", i, "markers processed in", round(as.numeric((proc.time()-time_)[3])/60, digits = 1),
                              "minutes (", round(i/as.numeric((proc.time()-time_)[3]), digits = 2), "markers/sec, Chr", 
                              chr_ant, ") --> ", counter, "segments with CN>",option$fr,"%      ")
    ##Preprocessing & Genotype & CNV analysis
    chr_ant <- as.numeric(chr)
    dat     <- as.numeric(dat[4:length(dat)])
    A       <- dat[seq(1, length(dat), 2)]
    A       <- A[inputs]
    B       <- dat[seq(2, length(dat), 2)]
    B       <- B[inputs]
    AB      <- t(rbind(A, B))
    input   <- which((AB[, 1] > -0.5) & (AB[, 2] > -0.5))
    AB      <- AB[input, ]
    plate   <- plates[inputs]
    plate   <- plate[input]
    TcnvA   <- matrix(-1, 1, LT)
    TcnvB   <- matrix(-1, 1, LT)
    def     <- preprocessing(AB, verbose = verbose, plate = plate)
    AB      <- def$AB
    if (any("ok" == names(def))){
        if(def$ok != 0) {
            if( option$pdfplot != -1 ) IT[((2*(i%%option$nmarkers+1))-1):(2*(i%%option$nmarkers+1)),input] <- t(def$FI)
            out_gt <- try(genotype.marker(def$FI, verbose = verbose), silent = FALSE)
            if(length(names(out_gt)) == 3){  
                AB  <- norm_gt(AB, out_gt$data_gen)
                def <- try(cnv.genotype(AB, out_gt$data_gen, verbose = verbose), silent = FALSE)
                if (any("ok" == names(def))){
                    if (def$ok == 1) {
                        TcnvA[1, input] <- round(100*def$TcnvA)/100
                        TcnvB[1, input] <- round(100*def$TcnvB)/100
                    }
                }
            }
        }
    }
    index <- which((TcnvA[1, ] == -1) | (TcnvB[1, ] == -1))
    TcnvT <- matrix(TcnvA[1, ] + TcnvB[1, ], 1, LT)
    TcnvT[1, index] <- 2
    cat(snp, chr, bpr, TcnvT[1, ], "\n", sep = "\t", file = fscore)
    ST[i%%option$nmarkers+1, 2:(LT+1)] <- TcnvT[1, ] 
    ##Per-probe case/control test
    ##if(length(status) > 1){
    ##    CN <- c(100 * length(which(TcnvT < option$LI)) / LT, 100*length(which(TcnvT > option$LS)) / LT)
    ##    if((CN[1] + CN[2]) > option$fr) {  
    ##        marker.analysis(chr_ant, bpr, snp, output_path, TcnvT, AB, option, controls, cases, ftest2)
    ##    }
    ##}
}
cat("\r", i, "markers processed in", round(as.numeric((proc.time()-time_)[3])/60, digits = 1),
                              "minutes --> ", counter, "segments with CN>",option$fr,"%                                   ")
cat("\n")
close(data)
close(fscore)
close(ftest)
##if (length(status)>1) close(ftest2)
options(warn = 1)
}
