`cnv.genotype` <-
function(AB, gt, verbose){

L <- dim(AB)[1]
m0 <- list(M = matrix(0, 2, 1),C =matrix(1, 2, 1) ,W = matrix(0, 2, 1), L = rep(Inf, 3))
dim(m0$C) <- c(1, 1, 2)
##########################################
cA <- cnv.init(AB[, 1], 1, gt)
if(any("mode" == names(cA))){
    if(cA$mode == 2){
        A_model <- cnv.gmm(AB[, 1], cA, verbose)
    } else if(cA$mode == 1){
        A_model <- list(model = m0, labels = matrix(0, 1, L))
    } else{
        return(list(ok = 0))
    }
} else{
    return(list(ok = 0))
}
if(verbose != 0) {
    cat("\tCNV SCORING\n\t\tPlot channel A OK... Press ENTER to continue.")
    readline()
    par(mfrow=c(1,1))
    par(mar=c(5, 4, 4, 2) + 0.1)
}
##########################################
cB <- cnv.init(AB[, 2], 3, gt)
if(any("mode" == names(cB))){
    if(cB$mode == 2){
        B_model <- cnv.gmm(AB[, 2], cB, verbose)
    } else if(cB$mode == 1){
        B_model <- list(model = m0, labels = matrix(0, 1, L))
    } else{
        return(list(ok = 0))
    }
} else{
    return(list(ok = 0))
}
if(verbose != 0) {
    cat("\t\tPlot channel B OK... Press ENTER to continue.\n\t\t")
    readline()
    par(mfrow=c(1,1))
    par(mar=c(5, 4, 4, 2) + 0.1)
}
##########################################
tcnvA <- matrix(A_model$label,1,L)
tcnvB <- matrix(B_model$label,1,L)

return(list(ok = 1, A_model = A_model$model, B_model = B_model$model, TcnvA = tcnvA, TcnvB = tcnvB))
}