`cnv.gmm` <-
function(xd, c_init, verbose = 0){

save    <- xd
x       <- xd[which(xd > c_init$Lim[1])]
dim(x)  <- c(length(x), 1)

model <- list()
model$M <- matrix(c(c_init$model$M[1, 1], c_init$model$M[2, 1]), 2, 1)
model$W <- matrix(c(c_init$model$W[1, 1], c_init$model$W[2, 1]), 2, 1)
model$C <- 0.25*c_init$model$C
dim(model$C) <- c(1, 1, 2)
sc <- 3
xd <- sort(xd)
x=seq(0, 3, 0.01)
if (verbose == 1){
    par(mar=c(4,5,2.5,2)+0.1)
    par(mfrow=c(2,1))
    hi <- hist(xd[which(xd<sc)], breaks = 40, plot = FALSE)
    plot(hi$mids, hi$counts,col="black", type="l", lwd=1,cex = 0.6, main = "(a) Single-locus analysis", xlab = "Channel intensity", ylab = "Histogram / Samples", xlim = c(0, max(xd)+0.2),axes=F,font=2)
    polygon(c(0,hi$mids,hi$mids[length(hi$mids)],0), c(0,hi$counts,0, 0), col='black',density=c(10,10),border="NA",angle=45)
    points(xd, (max(hi$counts/length(xd)))*(1:length(xd)), col = "black",  cex=0.5)
    axis(side=2,at=seq(0,max(hi$counts),round(100*max(hi$counts))/1000),line=0.5,font=2)
    abline(v=seq( 0, sc, round(10*sc)/100),col="grey",lty=3,lwd=0.8)
    abline(h=seq(0,max(hi$counts),round(100*max(hi$counts))/1000),col="grey",lty=3,lwd=0.8)
    box()
    m1 <- model$W[1, 1]*dnorm(x, model$M[1, 1], sqrt(model$C[1, 1, 1]))
    m2 <- model$W[2, 1]*dnorm(x, model$M[2, 1], sqrt(model$C[1, 1, 2]))
    lines(x, (max(hi$counts)/max(c(m1,m2)))*m1, col = "blue", lwd = 0.8,lty = 1)
    lines(x, (max(hi$counts)/max(c(m1,m2)))*m2, col = "red", lwd = 0.8, lty = 1)
    abline(v = c_init$Lim[1], lty = 3, lwd=2, col = "black")
}
xd     <- xd[which(xd>c_init$Lim[1])]
dim(xd)<- c(length(xd), 1)
model  <- emgmm.em(xd, model, c(1e-5,0.05), 15, 0.1)
model  <- model$model
m1     <- model$W[1, 1]*dnorm(x, model$M[1, 1], sqrt(model$C[1, 1, 1]))
m2     <- model$W[2, 1]*dnorm(x, model$M[2, 1], sqrt(model$C[1, 1, 2]))
int    <- which.max(m1)+which.min(abs(m1[which.max(m1):which.max(m2)]-m2[which.max(m1):which.max(m2)]))-1
if( verbose == 1){
    lines(x, (max(hi$counts)/max(c(m1,m2)))*m1, col = "blue", lwd = 2.8, lty = 1)
    ##polygon(c(0,x,x[length(x)],0), c(0,(max(hi$counts)/max(c(m1,m2)))*m1,0, 0), col='blue',density=c(15,15),border="NA",angle=-45)
    lines(x, (max(hi$counts)/max(c(m1,m2)))*m2, col = "red", lwd = 2.8, lty = 1)
    ##polygon(c(0,x,x[length(x)],0), c(0,(max(hi$counts)/max(c(m1,m2)))*m2,0, 0), col='red',density=c(15,15),border="NA",angle=45)
    abline(v = x[int], lty = 3, lwd=2, col = "black")
    axis(side=1,at=seq( 0, sc, round(10*sc)/100),line=0.5,font=2)
}

if ( ((max(m1)/m1[int])>1.5) & ((max(m2)/m2[int])>1.5) & (model$M[1,1]>0.3) & (model$M[1,1]<0.7) & (model$M[2,1]>0.7)){
    label <- matrix(0, 1, length(save))
    p     <- matrix(x[int],1,1)
    prob1 <- 1/emgmm.pdfgauss(p, model)
    prob2 <- 1/emgmm.pdfgauss(matrix(c(model$M[1,1],model$M[2,1]),2,1), model)
    ##RANGE 0 & 1
    label[1, which(save <  c_init$Lim[1])] <- 0
    label[1, which((save >= c_init$Lim[1])&(save < model$M[1,1]))] <- 1
    ##RANGE 1-1.5
    vals  <- which((save >= model$M[1,1])&(save < x[int]))
    m     <- save[vals]
    dim(m)<- c(length(m),1)
    label[1, vals] <- 1 + 0.5*((1/emgmm.pdfgauss(m, model)[1,])-prob2[1,1])/(prob1[1,1]-prob2[1,1])
    ##RANGE 1.5-2
    vals <- which((save >= x[int])&(save <= model$M[2,1]))
    m     <- save[vals]
    dim(m)<- c(length(m),1)
    label[1, vals] <- 2 - 0.5*((1/emgmm.pdfgauss(m, model)[2,])-prob2[2,2])/(prob1[2,1]-prob2[2,2])
    ##RANGE 2-3
    a1<-median(save[which((save >= x[int])&(save < model$M[2,1]+(model$M[2,1]-x[int])))])
    va<-var(save[which((save >= x[int])&(save < model$M[2,1]+(model$M[2,1]-x[int])))])
    model2 <- model
    if (a1 > model$M[2,1]) label[1, which((save >= model$M[2,1])&(save < a1))] <- 2
    label[1, which(save >= a1+3*sqrt(va))] <- 3
    model2$M[2,1]  <- a1
    model2$C[1,1,2]<- va
    vals <- which((save>=a1)&(save<(a1+3*sqrt(va))))
    p1   <- 1/emgmm.pdfgauss(matrix(a1,1,1), model2)
    p2   <- 1/emgmm.pdfgauss(matrix(a1+3*sqrt(va),1,1), model2)    
    label[1,vals] <- 2 + ((1/emgmm.pdfgauss(matrix(save[vals],length(vals),1), model2)[2,])-p1[2,1])/(p2[2,1]-p1[2,1])
    if (verbose==1){
        abline(v = a1+3*sqrt(va), lty = 3, lwd=2, col = "black")
        par(mar=c(5,5,3,2)+0.1)
        plot(save,label,col="black",panel.first = grid(NA,c(0,1,1.5,2,2.5,3), lty=1,lwd=1),cex = 0.8, main = "(b) Single-locus scoring", xlab = "Channel intensity", ylab = "Scores", xlim = c(0, max(xd)+0.2),font=2)
        grid()
        ##dev.off()
    }
}else{
    label <- matrix(-1, 1, length(save))
}
out <- list(model = model, label = label)
return(out)
}


