`cnv.plot.gmm` <-
function(i, xd, model){

xd <- sort(xd)
sc <- min(c(3, max(xd)))
m1 <- model$W[1, 1]*dnorm(seq(0, 3, 0.01), model$M[1, 1], sqrt(model$C[1, 1, 1]))
m2 <- model$W[2, 1]*dnorm(seq(0, 3, 0.01), model$M[2, 1], sqrt(model$C[1, 1, 2]))
m3 <- model$W[3, 1]*dnorm(seq(0, 3, 0.01), model$M[3, 1], sqrt(model$C[1, 1, 3]))
hi <- hist(xd[which(xd<sc)], breaks = 30, plot = FALSE)
M <- max(c(max(m1), max(m2), max(m3)))
sc2 <- length(xd)/max(hi$counts)
x=seq(0, 3, 0.01)

ge<-split.screen(c(2,1))
par(mar=c(0,5,3,3)+0.1)
screen(ge[1])
if(i == 1) plot(hi$mids, hi$counts*sc2,col="blue", type="l", lwd=2,cex = 0.6, main = "CNV Channel A",  ylab = "Histogram / Samples", xlim = c(0, sc),axes=F,font=2)
if(i == 2) plot(hi$mids, hi$counts*sc2,col="blue", type="l", lwd=2,cex = 0.6, main = "CNV Channel B",  ylab = "Histogram / Samples", xlim = c(0, sc),axes=F,font=2)
polygon(c(0,hi$mids,hi$mids[length(hi$mids)],0), c(0,hi$counts*sc2,0, 0), col='blue',density=c(15,15),border="NA")
points(xd, 1:length(xd), col = "black", pch=19, cex=0.8)
box()
axis(side=2,at=seq(0,length(xd),round(100*length(xd))/1000),line=0.5,font=2)
abline(v=seq( 0, sc, round(10*sc)/100),col="grey",lty=3,lwd=0.8)
abline(h=seq( 0, length(xd), round(10*length(xd))/100),col="grey",lty=3,lwd=0.8)

abline(v = model$L, lty = 3, lwd = 2, col = "black")

screen(ge[2])
par(mar=c(5,5,0,3)+0.1)
plot(0, 0,col="black", cex=0.001,ylab = "Density distribution", xlab = "Channel intensity",  ylim = c(0, M), xlim=c(0, sc),axes=F)
box()
axis(side=2,at=seq(0,M,round(10*M)/100),line=0.5,font=2)
axis(side=1,at=seq( 0, sc, round(10*sc)/100),line=0.5,font=2)
abline(v=seq( 0, sc, round(10*sc)/100),col="grey",lty=3,lwd=0.8)
abline(h=seq( 0, M, round(10*M)/100),col="grey",lty=3,lwd=0.8)
lines(x, m1, col = "black", lwd = 2, lty = 1)
polygon(c(0,x,x[length(x)],0), c(0,m1,0, 0), col='blue',density=c(25,25),border="NA",angle=-45)
lines(x, m2, col = "black", lwd = 2, lty = 1)
polygon(c(0,x,x[length(x)],0), c(0,m2,0, 0), col='red',density=c(25,25),border="NA",angle=0)
lines(x, m3, col = "black", lwd = 2, lty = 1)
polygon(c(0,x,x[length(x)],0), c(0,m3,0, 0), col='blue',density=c(25,25),border="NA",angle=45)
abline(v = model$L, lty = 3, lwd=2, col = "black")
text(y = M,  x = model$L[1],  labels = "Limit 0-1",  adj = c(1, 1), cex = 0.8, col = "black", srt = 90, font = 2)
text(y = M,  x = model$L[2],  labels = "Limit 1-2",  adj = c(1, 1), cex = 0.8, col = "black", srt = 90, font = 2)
text(y = M,  x = model$L[3],  labels = "Limit 2-3",  adj = c(1, 1), cex = 0.8, col = "black", srt = 90, font = 2)
close.screen(all.screens=TRUE)
par(mar=c(5, 4, 4, 2) + 0.1 )

}

