`emgmm.em` <-
function(x, model, limvar = c(0, Inf), max_iter = 50, dlog = 1e-02){

ndim   <- dim(x)[2]
ncomp  <- dim(model$M)[1]
LLH    <- rep(0, max_iter+2)
LLH[1] <--Inf
exit_flag  <- 0
iter_count <- 0

while(exit_flag == 0){
    for (i in 1:ncomp){
        if (model$C[1, 1, i] < limvar[1]) model$C[1, 1, i]      <- limvar[1]
        else if (model$C[1, 1, i] > limvar[2]) model$C[1, 1, i] <- limvar[2]
    }
    ER <- emgmm.e_step(x, model)
    if(ER$LLH-LLH[iter_count+1] <= dlog | iter_count+1 > max_iter){
        exit_flag <- 1
        LLH[iter_count+2] <- ER$LLH
    }
    else{
        LLH[iter_count+2] <- ER$LLH
        old_model  <- model
        model      <- emgmm.m_step(x, ER$Alpha)
        iter_count <- iter_count+1
    }
}

for (i in 1:ncomp){
    if (model$C[1, 1, i] < limvar[1])    model$C[1, 1, i] <- limvar[1]
    if (model$C[1, 1, i] > limvar[2])    model$C[1, 1, i] <- limvar[2]
}
return(list(model = model, iters = iter_count, LLH = LLH[iter_count+1], dlogL = LLH[iter_count+1]-LLH[2]))
}

