`emgmm.m_step` <-
function(x, Alpha){

ncomp <- dim(Alpha)[1]
ndata <- dim(x)[1]
ndim  <- dim(x)[2]

model <- list(M = matrix(0, ncomp, ndim), C = rep(matrix(0, ndim, ndim), ncomp), W = matrix(0, ncomp, 1))
dim(model$C) <- c(ndim, ndim, ncomp)

for (i in 1:ncomp){
    nconst <- sum(Alpha[i, ])
    if (nconst < 1e-6){
        model$W[i, 1] <- 0
    }
    else {
        j      <- Alpha[i, ]
        dim(j) <- c(1, ndata)
        model$M[i, ]  <- (1/nconst)*j%*%x
        model$W[i, 1] <- nconst/ndata
        xc <- x-t(matrix(rep(model$M[i, ], ndata), ndim))
        jj <- (matrix(rep(j, ndim), ndim, byrow = TRUE))
        xx <- xc*t(jj)
        model$C[, , i] <- t(xx)%*%xc/nconst
    }
}
return(model)
}