`emgmm.pdfgauss` <-
function(x, model)
{
ndim  <- dim(model$M)[2]
ndata <- dim(x)[1]
ncomp <- dim(model$M)[1]
m     <- matrix(0, ncomp, ndata)
if (ndim > 1){
    for (i in 1:ncomp){
        if(model$W[i,1] != 0){
            d <- mahalanobis(x, model$M[i, ], model$C[, , i])
            m[i, ] <- exp(-0.5*d)*(1/(2*pi*sqrt(abs(det(model$C[, , i])))))
        }
        else m[i, ] <- rep(0, ndata)
    }
}
else{
    for (i in 1:ncomp){
        if(model$W[i, 1] != 0) m[i, ] <- exp(-0.5*(  (x-model$M[i, ])^2  )/model$C[, , i])*(1/(sqrt(2*pi*model$C[, , i])))
        else m[i, ] <- rep(0, ndata)
    }
}
return(m)
}