`genotype.compute` <-
function(data, max_dev = 1, limvar = c(1e-4, 0.04), mdlog = 0.1, max_iter = 2){

I <- data[, 2]
F <- data[, 1]

## ALLELIC FREQUENCY CENTRES SEARCH
f_peaks <- genotype.findpeaks(data[, 1])

if(length(f_peaks$H) > 3){
    out <- c(-1, -1, -1)
    L1 <- which(f_peaks$C < 0.25)
    L2 <- which(f_peaks$C > 0.25 & f_peaks$C < 0.75)
    L3 <- which(f_peaks$C > 0.75)
    if(length(L1) > 1){
        ji     <- sort(f_peaks$H[L1], index.return = TRUE, decreasing = TRUE)
        out[1] <- f_peaks$C[L1[ji$ix[1]]]
    } else if(length(L1) == 1) out[1] <- f_peaks$C[L1]
    if(length(L2) > 1){
        ji     <- sort(f_peaks$H[L2], index.return = TRUE, decreasing = TRUE)
        out[2] <- f_peaks$C[L2[ji$ix[1]]]
    } else if(length(L2) == 1) out[2] <- f_peaks$C[L2]
    if(length(L3) > 1){
        ji     <- sort(f_peaks$H[L3], index.return = TRUE, decreasing = TRUE)
        out[3] <- f_peaks$C[L3[ji$ix[1]]]
    } else if(length(L3) == 1) out[3] <- f_peaks$C[L3]
    f_peaks$C <- out[which(out != -1)]
}

f_peaks <- sort(f_peaks$C)
if(length(f_peaks) == 3){
    if(f_peaks[3] < 0.75 & f_peaks[1] > 0.25) f_peaks <- f_peaks[2]
    else{
        if(f_peaks[3] < 0.75) f_peaks <- c(f_peaks[1],mean(f_peaks[2:3]))
        else{
            if(f_peaks[1] > 0.25) f_peaks <- c(mean(f_peaks[1:2]),f_peaks[3])
        }
    }
}
if(length(f_peaks) == 2){
    if(f_peaks[1] < 0.25 & f_peaks[2] < 0.25) f_peaks <- mean(f_peaks[1:2])
    else{
        if(f_peaks[1] > 0.75 & f_peaks[2] > 0.75) f_peaks <- mean(f_peaks[1:2])
        else{
            if(f_peaks[1] > 0.25 & f_peaks[2] > 0.25 & f_peaks[1] < 0.75 & f_peaks[2] < 0.75) f_peaks <- mean(f_peaks[1:2])
        }
    }
}


Nclusters <- length(f_peaks)
labels    <- matrix(2, dim(data)[1], 1)
## LABEL DATA
if(Nclusters == 3){
    labels[which(data[, 1] < mean(f_peaks[1:2])), ] <- 1
    labels[which(data[, 1] > mean(f_peaks[2:3])), ] <- 3
}
if(Nclusters == 2){
    if(mean(data[, 1]) < 0.5) labels[which(data[, 1] < mean(f_peaks)), ] <- 1
    else labels[which(data[, 1] > mean(f_peaks)), ] <- 3}
if(Nclusters == 1){
    i_lims <- c(0.25, 0.75)
    if(mean(data[, 1]) < i_lims[1]) labels <- matrix(1, dim(data)[1], 1)
    else if(mean(data[, 1]) > i_lims[2]) labels <- matrix(3, dim(data)[1], 1)
}
NL    <- c(length(which(labels == 1)), length(which(labels == 2)), length(which(labels == 3)))
model <- list(M = matrix(-1, 3, 2), C = matrix(0, 4, 3), W = matrix(0, 3, 1))
dim(model$C) <- c(2, 2, 3)
flag  <- 0
for(i in 1:3){
    if(NL[i] > 2){
        L <- which(labels[, 1] == i)
        y <- data[L,]
        m <- apply(y, 2, mean)
        d <- (y - t(matrix(rep(m, NL[i]), 2, NL[i])))^2
        index <- which( (abs(d[, 1]-mean(d[, 1])) < max_dev*sqrt(var(d[, 1]))) | (abs(d[, 2]-mean(d[, 2])) < 2*max_dev*sqrt(var(d[, 2]))))
        if(length(index)<3) index <- 1:length(d[,1])
        else index <- 1:length(d[,1])
        if(length(index) > 2){
            y <- y[index, ]
            if (flag == 0){
                x    <- y
                good <- L[index]
                flag <- 1
            }
            else {
                x    <- rbind(x, y)
                good <- c(good, L[index])
		}
            model$M[i, ] <- apply(y, 2, mean)
            y <- cov(y)
            if(y[1, 1] > limvar[2]) y[1, 1] <- limvar[2]
            if(y[1, 1] < limvar[1]) y[1, 1] <- limvar[1]
            model$C[, , i] <- y
            model$W[i, ] <- NL[i]/sum(NL)
        }
    } 
}
index <- good
LLH   <- emgmm.e_step(x, model)
LLH   <- LLH$LLH
iters <- 0
out   <- emgmm.em(x, model, limvar, 1, mdlog)
out$model$M[which(out$model$W == 0),] <- -1
model <- out$model
pdf   <- emgmm.pdfgauss(data, model)
data_gen <- matrix(0, 1, dim(pdf)[2])
for (i in 1:dim(pdf)[2]){
    data_gen[1, i] <- which(pdf[, i]==max(pdf[,i]))[1]
}
return(list(data_gen = data_gen, index = index, model = model))
}

