`genotype.marker` <-
function(FI, verbose = 0){
    out_gt  <- genotype.compute(FI)
    cluster <- c(0, 0, 0)
    L       <- c(0.007,0.02,0.007)
    for (i in 1:3){
        if (out_gt$model$C[1,1,i]>L[i]){
            out_gt$data_gen[]<-0
            cluster[i] <- 1
        }
    }
    if(verbose != 0){
        cat("\tGENOTYPING\n\t\tSamples per genotype: ", length(which(out_gt$data_gen==1)), ",", length(which(out_gt$data_gen==2)), ",", length(which(out_gt$data_gen==3)))
        par(mfrow = c(1, 1))
        genotype.plot.result(FI, out_gt)
        if(verbose == 1){
            cat("\n\t\tPlot OK... Press ENTER to continue.")
            readline()
        }
    }
    return(out_gt)
}
