`genotype.plot.pdf` <-
function(model, add = FALSE, xlim = c(-0.1, 1.1), ylim = c(0, 2.4), steps = 120, opt = 0){
x  <- seq(xlim[1], xlim[2], (xlim[2]-xlim[1])/steps)
x1 <- rep(x, each = length(x))
y  <- seq(ylim[1], ylim[2], (ylim[2]-ylim[1])/steps)
y1 <- rep(y, length(x))
gr <- cbind(x1, y1)
J  <- emgmm.pdfgauss(gr, model)
if(opt == 1){
    J<-J*matrix(rep(model$W, dim(gr)[1]), dim(model$W)[1], dim(gr)[1])
}
J <- apply(J, 2, sum)
dim(J) <- c(length(x), length(y))
contour(x, y, log(t(J)), nlevels = 15, col = "black", add = add)
}