`genotype.plot.result` <-
function(FI, gt_struct, tit = ""){

model <- gt_struct$model
index <- gt_struct$index
label <- gt_struct$data_gen[1,]
plot(FI, col = "black", pch = 19, cex=0.5, xlab = "ALLELE FREQUENCY", ylab="ABSOLUTE INTENSITY", xlim = c(-0.1, 1.1), ylim = c(0, 2.4))
grid(lwd = 1, lty = 1)
par(xaxp = c(0, 1, 10))
genotype.plot.pdf(model, TRUE)
title(main = paste("GENOTYPE:", tit, sep=" "))
points(FI[index[which(label[index] == 1)], ], col="red", pch = 19, cex = 0.5)
points(FI[index[which(label[index] == 2)], ], col="green", pch = 19, cex = 0.5)
points(FI[index[which(label[index] == 3)], ], col="blue", pch = 19, cex = 0.5)
legend(x = "topright", fill = c("black", "red", "green", "blue"), legend = c("Outlier", "AA", "AB", "BB"), bg = "white", cex = 0.5)
legend(x = "bottomleft", legend = c(paste("Final LLH=", gt_struct$LLH), paste("LLH GAIN=", gt_struct$dLLH)), bg = "white", cex = 0.5)
}