`preprocessing.compute_fi` <-
function(x){

## APPLY SENSIBILITY THRESHOLD
x[which(x[, 1]<0.01), 1] <- 0.01
x[which(x[, 2]<0.01), 2] <- 0.01
## INTENSITY NORMALIZATION
i_norm <- preprocessing.compute_inorm(x)
if(length(which(i_norm == -1)) > 0) return(list(ok = 0))
else {
    x[, 1]  <- x[, 1]/i_norm[1]
    x[, 2]  <- x[, 2]/i_norm[2]
    FI      <- matrix(0, dim(x)[1], 2)
    FI[, 2] <- apply(x, 1, sum)              ## ABSOLUTE INTENSITY
    FI[, 1] <- (2/pi)*atan(x[, 2]/x[, 1])    ## ALLELIC FREQUENCY
    return(list(ok = 1,FI = FI, AB = x, i_norm = i_norm))
}
}

