`preprocessing.compute_inorm` <-
function(x){

i_lims = c(0.15, 0.85)
F  <- x[, 2]/x[, 1]
AA <- which(F < tan(i_lims[1]*pi/2))    ## CADIDATE HOMOZYGOTES AA
BB <- which(F > tan(i_lims[2]*pi/2))    ## CADIDATE HOMOZYGOTES BB
i_norm = c(-1, -1)                      ## i_norm default values

if(length(AA) > 4 & length(BB) > 4){    ## AA & BB HOMOZYGOTES
    i_norm[1] <- median(x[AA, 1])
    i_norm[2] <- median(x[BB, 2])
}
else {
    if(length(AA) > 4 & length(BB) < 5){   ## NO BB HOMOZYGOTES
        i_norm[1] <- median(x[AA, 1])
        i_norm[2] <- i_norm[1]
    }
    else{
        if(length(AA) < 5 & length(BB) > 4){   ## NO AA HOMOZYGOTES
            i_norm[2] <- median(x[BB, 2])
            i_norm[1] <- i_norm[2]
        }
    }
}
return(i_norm)
}