`segment.plot` <-
function(pdfplot, chr_ant, RES, ST, IT, option){

pdf(file = paste(pdfplot,"/segment_chr",chr_ant,"bp",min(ST[,1]),"_",max(ST[,1]),".pdf",sep=""),width = 9, height = 15,  pointsize=12,bg = "transparent")
par(mfrow=c(2,1))
m<-sort(ST[,1],index.return=TRUE)
plot(ST[m$ix,1],ST[m$ix,2],type="p",col="blue",pch = 19,cex = 0.3,ylim = c(-0.2, 3.5),main=paste("chr",chr_ant,":",min(ST[,1]),"..",max(ST[,1]),sep=""),xlab="Basepair",ylab="CN Score")
for (ij in which(RES[1,]==0)){
    points(ST[m$ix,1],ST[m$ix,1+ij],col="blue",cex=0.3,pch=19)
    lines( ST[m$ix,1],ST[m$ix,1+ij],col="blue")
}
for (ij in which(RES[1,]!=0)){
    points(ST[m$ix,1],ST[m$ix,1+ij],col="red",cex=0.3,pch=19)
    lines( ST[m$ix,1],ST[m$ix,1+ij],col="red")
}
grid()
legend(x = "topright", fill = c("blue", "red"), legend = c("CN=2","CN!=2"), bg = "white", cex = 0.5)
plot(  IT[m$ix[1]*2-1,which(RES[1,]==0)],IT[m$ix[1]*2,which(RES[1,]==0)],type="p",col="blue",cex = 0.3,xlim = c(-0.2, option$nmarkers+0.2),ylim = c(-0.2, 3.5),xlab="MARKER (BAF)",ylab="Total intensity")
points(IT[m$ix[1]*2-1,which(RES[1,]!=0)],IT[m$ix[1]*2,which(RES[1,]!=0)],type="p",col="red" ,cex = 0.3)
for (ij in 2:option$nmarkers){
    points(IT[m$ix[ij]*2-1,which(RES[1,]==0)]+ij-1,IT[m$ix[ij]*2,which(RES[1,]==0)],type="p",col="blue" ,cex = 0.3)
    points(IT[m$ix[ij]*2-1,which(RES[1,]!=0)]+ij-1,IT[m$ix[ij]*2,which(RES[1,]!=0)],type="p",col="red" ,cex = 0.3)
}
grid()
for (ij in 0:option$nmarkers){
    abline(v=ij, lwd = 1, col = "black")
}
dev.off()

}