\name{CN.stream}
\alias{CN.stream}
\title{CN.stream }
\description{
   Performs CNV analysis (CNstream main function)
}
\usage{
CN.stream(f_data, output_path, status = -1, norm_plate = -1, verbose = 0, option = -1)
}
\arguments{
  \item{f_data}{Path to the file containing the intensity data of the markers to be analyzed, sorted by chromosome and basepair. 
  At each line, fields one to three must contain the marker description (name, chromosome, basepair), while the remaining columns 
  are reserved to the X and Y sample intensities.
  }
  \item{output_path}{Path to the output directory where the result files will be saved.}
  \item{status}{(optional) Path to the file containing, at each line, the case/control status (1 or 0) of the samples.}
  \item{norm_plate}{(optional) Path to file containing, at each line, the plate number of the samples.}
  \item{verbose}{If verbose = 1, detailed plots and information will be screened for each probe (not recommended for whole-genome analysis).}
  \item{option}{
    List containing the following analysis parameters:
    
    \item{segment_length}{Segment kb length (\code{default = 100}).}
    \item{nmarkers}{Number of probes per segment (\code{default = 5}).}
    \item{minmarkers}{Minimum number of probes passing the threshold (score<LI | score>LS) for calling a deletion or an amplification (\code{default = 3}).}
    \item{fr}{Frequency threshold (\code{default = 1}).}
    \item{LI}{Deletion threshold (\code{default = 1.65}).}
    \item{LI}{Amplification threshold (\code{default = 2.7}).}
    \item{pdfplot}{If pdfplot != -1, detailed figures corresponding to CNP segments and significant markers will be saved
    in the output path as PDF documents.}
   }
}
\details{
  CN.stream is the package main function. The analysis can be run either over small segments with a few number of markers, or over
  whole genome data. When analyzing small candidate regions with few number of markers, the option \code{verbose=1} can be useful
  in order to verify and understand the results, since detailed figures of the analysis are screened. However, when analyzing whole-genome
  data, this option is not recommended, but the user can select \code{option$pdfplot=1} and a resuming figure will be saved for
  each CNP segment exceeding the minimum frequency threshold indicated in \code{option$fr}.
  
  The input file \code{f_data} can be created from a BeadStudio project: In the "Column chooser" we should place first "Name", "Chr" and "Position" 
  in the "Displayed Columns" field, followed by the IDs of all the samples that are going to be analyzed. In the "Displayed Subcolumns" 
  field we must select "X" and "Y", obtaining two data columns for each sample. After that, in the "Sort by multiple columns" option, 
  we must select "Sort by chromosome, then by basepair". Finally, the input file for CNstream is created by using the option "Export displayed data to a file".
  
  CNstream results are saved in three output files:

  \code{CNstream_scores.txt} In this file the scores computed for each sample at each marker will be saved.
  \code{CNstream_CNPseg.txt} In this file information of the CNP segments exceeding the minimum frequency 
  threshold (option$fr) will be saved. When case/control status is provided, the result of the chi-square association test is also saved.
  \code{CNstream_marker.txt} If Case/Control status is provided, file where the significant per-marker association results
  will be saved.   

  If a file with the case/control status is provided, each line will represent the status of the corresponding sample in the \code{f_data}. For example,
  a 0 in the first line indicates that the sample placed in the first column of the \code{f_data} file is a control. On the other side, a 1 will indicate
  that this sample is a case.
  
  If a file with the plate numbers is provided, each line will represent the plate where the corresponding sample in the \code{f_data} file was genotyped.
  Samples with plate number equal to 0 will be considered as outliers.
}
\value{
  Any value is returned. All the results are saved in the output files. 
}
\references{Alonso et al (2009) \sQuote{titolpaper}. Submitted for publication.}
\author{A.Alonso, A.Juli and S.Marsal}
\examples{
##Input data
f_data     <- "http://www.urr.cat/cnv/data/ex.txt"
norm_plate <- "http://www.urr.cat/cnv/data/plate.txt"
status     <- "http://www.urr.cat/cnv/data/status_all.txt"
##Results will be placed in the R work directory
output_path<- "./" 
##Run analysis without providing a status file
verbose <- 0
CN.stream(f_data, output_path, -1, norm_plate, verbose)
##Run analysis with default parameters
verbose   <- 1   ## The analysis details of each marker will be screened as the analysis goes on
CN.stream(f_data, output_path, status, norm_plate, verbose)
verbose   <- 0   ## Avoids screening the details for each marker
CN.stream(f_data, output_path, status, norm_plate, verbose)
option    <- list(fr = 5)  ## If we only want to analyze CNPs with a frequency higher or equal than 5%
option$pdfplot <- 1 ## If we want CNstream to save pdf plots of the CNP segments 
CN.stream(f_data, output_path, status, norm_plate, verbose, option)
}
\eof