\name{cnv.genotype}
\alias{cnv.genotype}
\title{CNV analysis}
\description{
   Method for CNV single-locus scoring.
}
\usage{
cnv.genotype(AB, gt, verbose)
}
\arguments{
  \item{AB}{ 
    data matrix, each row corresponding to a sample,
    column 1 corresponding to channel A intensities,
    column 2 corresponding to channel B intensities.
  }
  \item{gt}{Genotypes computed for each sample.}
  \item{verbose}{If verbose = 1, figures resuming the results will be screened.}
}
\details{
    It performs the analysis of the intensities corresponding to both channels
    and returns the final GMM models of each channel and the score of each sample.
}
\value{
  \item{ok}{If 0, scoring error.}
  \item{A_model}{CNV model parameters for channel A intensities.}
  \item{B_model}{CNV model parameters for channel B intensities.}
  \item{TcnvA}{CN scores for channel A.}
  \item{TcnvB}{CN scores for channel B.}
}
\author{A.Alonso, A.Juli and S.Marsal}