\name{cnv.init}
\alias{cnv.init}
\title{GMM initialization for CNV analysis}
\description{Determines the initialization model for the EM algorithm when
analyzing one channel intensity data for CNV detection.}
\usage{
cnv.init(x, I, label)
}
\arguments{
  \item{x}{Intensity samples of one channel.}
  \item{I}{Defines the genotype label corresponding
   to homozygotes measured by the analyzed channel.
     \item{Channel A }{I=1}  
     \item{Channel B }{I=3}
  }
  \item{label}{Genotype labels (1, 2 or 3).}
}
\details{
First computes the "zero-copy" threshold. Then, the "non-zero copy" samples are used 
to estimate the "one copy" model (heterozygote intensity samples with genotype label 2) 
and the "two copies" model (homozygote intensity samples with genotype label I).
}
\value{
  \item{mode}{if "0", error, if "1", only "zero copy" samples, else, all models computed.}
  \item{Lim = c(L0,0,0)}{L0 defines the upper threshold of "zero copy" samples.}
  \item{model }{Computed models, if mode==2.}
}
\author{A.Alonso, A.Juli and S.Marsal}
\eof
