% --- Source file: emgmm.e_step ---
\name{emgmm.e_step}
\alias{emgmm.e_step}
\title{E-STEP GMM}
\description{
  E-Step of the Expectation-Maximization algorithm (Gaussian Mixture Models)
}
\usage{
emgmm.e_step(x, model)
}
\arguments{
  \item{x}{
    Data matrix. Each row corresponding to an observation,
    and each column corresponding to a variable. 
    \code{dim=[Ndata,Ndim]}
  }
  \item{model}{
    Gaussian Mixture Model:
    \item{M}{GMM mean vectors: \code{dim=[Ncomp,Ndim]}.}
    \item{C}{GMM covariance matrix: \code{dim=[Ndim,Ndim,Ncomp]}.}
    \item{W}{GMM weight values: \code{dim=[Ncomp,1]}.}
  }
}
\value{
  \item{LLH}{Final LLH value}
  \item{Alpha}{Responsabilities: \code{dim=[Ncomp,Ndata]})}
}
\details{
  This procedure is performed for microarray data. Then, only 1D and 2D
  data samples are allowed. Case examples:
  \item{1D}{CNV models, working with one channel intensity values.}
  \item{2D}{Genotype models, working with allelic frequency and intensity values.}
}
\author{A.Alonso, A.Juli and S.Marsal}
\seealso{
  \code{\link{emgmm.em}}, \code{\link{emgmm.pdfgauss}}, \code{\link{emgmm.m_step}}.
}
\eof
