\name{emgmm.em}
\alias{emgmm.em}
\title{GMM Expectation-Maximization algorithm}
\description{
  Performs the Expectation-Maximization algorithm for a GMM
}
\usage{
emgmm.em(x, model, limvar = c(0, Inf), max_iter = 50, dlog = 1e-02)
}
\arguments{
  \item{x}{
    Data matrix. Each row corresponding to an observation,
    and each column corresponding to a variable. 
    \code{dim=[Ndata,Ndim]}
   }
  \item{model}{
    \item{M}{Init GMM mean vectors: \code{dim=[Ncomp,Ndim]}.}
    \item{C}{Init GMM covariance matrix: \code{dim=[Ndim,Ndim,Ncomp]}.}
    \item{W}{Init GMM weight values: \code{dim=[Ncomp,1]}.}
   }
  \item{limvar}{
   \code{limvar = c(minimum,maximum)} Minimum and maximum variance values allowed.
   When working with 2D data (genotyping) thresholds are only applyed 
   to the B-allele frequency component, having the higher clustering sensibility. 
   }
  \item{max_iter}{
   Maximun number of EM iterations allowed.
   }
  \item{dlog}{
   Minimum Likelyhood Gain required for a new EM iteration.
   }
}
\details{
This procedure is performed for microarray data. 
Then, only 1D and 2D data samples are allowed. Case examples: 
\item{1D}{CNV models, working with one channel intensity values.}
\item{2D}{Genotype models, working with allelic frequency and intensity values.}
}
\value{
  \item{model}{
    \item{M}{Final GMM mean vectors: \code{dim=[Ncomp,Ndim]}.}
    \item{C}{Final GMM covariance matrix: \code{dim=[Ndim,Ndim,Ncomp]}.}
    \item{W}{Final GMM weight values: \code{dim=[Ncomp,1]}.}
  }
  \item{iters}{Number of iterations applyed.}
  \item{LLH}{Final LLH.}
  \item{dLogL}{LLH Gain between final model and init model.}
}
\author{ A.Alonso, A.Juli and S.Marsal }
\seealso{
  \code{\link{emgmm.em}}, \code{\link{emgmm.pdfgauss}},\code{\link{emgmm.e_step}},  \code{\link{emgmm.m_step}}.
}
\examples{
## The following example includes all the steps included on this routine
## but performing graphical views of the algorithm results.

## Creating sample data
n <- 50+runif(1,0,100)
x <- rbind(rnorm(n,runif(1,0,1),runif(1,1e-4,1e-1)),rnorm(n,runif(1,0,3),runif(1,1e-3,1)))
for (i in 1:8){
    n <- 50+runif(1,0,100)
    x <- cbind(x,rbind(rnorm(n,runif(1,0,1),runif(1,1e-4,1e-1)),rnorm(n,runif(1,0,3),runif(1,1e-3,1))))
}
x       <- t(x)
## Creating initialization model
model   <- list()
model$M <- rbind(c(0,0),
                 c(0, mean(x[, 2])), 
                 c(0, max(x[, 2])),
                 c(mean(x[, 1]), max(x[, 2])),
                 c( max(x[, 1]), max(x[, 2])), 
                 c( max(x[, 1]),mean(x[, 2])), 
                 c( max(x[, 1]), 0), 
                 c(mean(x[, 1]), 0), 
                 c(mean(x[, 1]), mean(x[, 2])))
model$W <- matrix(rep(1/9, 9), 9, 1)
model$C <- rep(c(1e-2, 0, 0, 1e-2), 9)
dim(model$C) <- c(2, 2, 9)
## Plotting data and initial model centers
plot(x, col = "blue", cex = 1.2)
points(model$M, col = "red", pch = 19, cex = 1)
text(model$M[, 1], model$M[, 2], rep(0, 6), pos = 4, col = "red")
## EM parameters
max_iter  <- 500
dlog      <- 1e-5
limvar    <- c(1e-10,10)
ndim      <- dim(x)[2]
ncomp     <- dim(model$M)[1]
exit_flag <- 0
iter_count<- 0
LLH       <- rep(0, max_iter+2)
LLH[1]    <- -Inf
## EM iterations
while(exit_flag == 0){
    for (i in 1:ncomp){
        for (j in 1:2){
    	      if (model$C[j, 1, i] < limvar[1])      model$C[j, 1, i] <- limvar[1]
	          else if (model$C[j, 2, i] > limvar[2]) model$C[j, 2, i] <- limvar[2]
        }	
    }
	  ER <- emgmm.e_step(x, model)
	  if(ER$LLH-LLH[iter_count+1] <= dlog | iter_count+1 > max_iter){
 		    exit_flag <- 1
        LLH[iter_count+2] <- ER$LLH
	  }	else{
		    LLH[iter_count+2] <- ER$LLH
		    old_model <- model
		    model <- emgmm.m_step(x, ER$Alpha)
		    iter_count <- iter_count+1
		    for (i in 1:ncomp) {
			      if(model$W[i, 1] != 0) {
				        points(t(model$M[i, ]), col = "red", pch = 19, cex = 0.8)	
				        lines((rbind(old_model$M[i, ], model$M[i, ])), col = "red")
			      }
		    }
    }
}
for (i in 1:ncomp) {
    if(model$W[i, 1] != 0) {
        points(t(model$M[i, ]), col = "red", pch = 19, cex = 1)	
        lines(rbind(old_model$M[i, ], model$M[i, ]), col = "red")
        text(model$M[i, 1], model$M[i, 2], iter_count, pos = 4, col = "red")	
    }
}
for (i in 1:ncomp){
    for (j in 1:2){
        if (model$C[j, 1, i] < limvar[1])      model$C[j, 1, i] <- limvar[1]
	      else if (model$C[j, 2, i] > limvar[2]) model$C[j, 2, i] <- limvar[2]
    }
}
genotype.plot.pdf(model, add = TRUE, xlim = c(min(x[, 1]), max(x[, 1])), ylim = c(min(x[, 2]), max(x[, 2])), 400, 1)
}
\eof